/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.MinMaxCalculator;
import loci.formats.in.LeicaReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.in.ZipReader;
import loci.formats.meta.MetadataStore;
import ome.formats.OMEXMLModelComparator;
import ome.formats.importer.ImportConfig;
import ome.util.PixelData;
import omero.model.Channel;
import omero.model.Pixels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMEROWrapper
extends MinMaxCalculator {
    private static final Logger log = LoggerFactory.getLogger(OMEROWrapper.class);
    private ChannelSeparator separator;
    private ChannelFiller filler;
    private Memoizer memoizer;
    public Boolean minMaxSet = null;
    private ImageReader iReader;
    private ImportConfig config;

    public OMEROWrapper(ImportConfig config) {
        this(config, -1L, null);
    }

    public OMEROWrapper(ImportConfig config, long elapsedTime, File cacheDirectory) {
        super(OMEROWrapper.createReader(config));
        this.config = config;
        this.iReader = (ImageReader)this.reader;
        this.reader = null;
        this.filler = new ChannelFiller(this.iReader);
        this.separator = new ChannelSeparator(this.filler);
        this.memoizer = new Memoizer(this.separator, elapsedTime, cacheDirectory){

            @Override
            public Memoizer.Deser getDeser() {
                Memoizer.KryoDeser k = new Memoizer.KryoDeser();
                k.kryo.register(OMEXMLModelComparator.class);
                return k;
            }
        };
        this.reader = this.memoizer;
        this.iReader.setMetadataFiltered(true);
        this.filler.setMetadataFiltered(true);
        this.separator.setMetadataFiltered(true);
        this.iReader.setFlattenedResolutions(false);
    }

    private static ImageReader createReader(ImportConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("An ImportConfig must be instantitated \n in order to properly configure all readers.");
        }
        String readersPath = (String)config.readersPath.get();
        ClassList<IFormatReader> readers = ImageReader.getDefaultReaderClasses();
        readers.removeClass(ZipReader.class);
        if (readersPath != null) {
            Class<OMEROWrapper> k = OMEROWrapper.class;
            if (new File(readersPath).exists()) {
                k = null;
            }
            try {
                return new ImageReader(new ClassList<IFormatReader>(readersPath, IFormatReader.class, k));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load readers.txt.");
            }
        }
        return new ImageReader();
    }

    public ImportConfig getConfig() {
        return this.config;
    }

    public PixelData openPlane2D(String id, int planeNumber, byte[] buf) throws FormatException, IOException {
        return this.openPlane2D(id, planeNumber, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public PixelData openPlane2D(String id, int planeNumber, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        ByteBuffer plane;
        if (this.iReader.isRGB() || this.isLeicaReader()) {
            byte[] bytePlane = this.openBytes(planeNumber, x, y, w, h);
            plane = ByteBuffer.wrap(bytePlane);
        } else {
            plane = ByteBuffer.wrap(this.openBytes(planeNumber, buf, x, y, w, h));
        }
        plane.order(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return new PixelData(FormatTools.getPixelTypeString(this.getPixelType()), plane);
    }

    public boolean isLeicaReader() {
        return this.iReader.getReader() instanceof LeicaReader;
    }

    public boolean isMinMaxSet() throws FormatException, IOException {
        if (this.minMaxSet == null) {
            MetadataStore store = this.reader.getMetadataStore();
            int series = this.reader.getSeries();
            List pixels = (List)((Object)store.getRoot());
            if (pixels == null) {
                this.minMaxSet = true;
                return this.minMaxSet;
            }
            Pixels p = (Pixels)pixels.get(series);
            Channel c = p.getChannel(p.getSizeC().getValue() - 1);
            this.minMaxSet = c.getStatsInfo() != null;
        }
        return this.minMaxSet;
    }

    @Override
    protected void updateMinMax(int no, byte[] buf, int len) throws FormatException, IOException {
        if (!this.isMinMaxSet()) {
            super.updateMinMax(no, buf, len);
        }
    }

    @Override
    public void close() throws IOException {
        this.minMaxSet = null;
        super.close(false);
    }

    public ImageReader getImageReader() {
        return this.iReader;
    }

    public boolean isSPWReader() {
        String[] domains = this.reader.getDomains();
        return Arrays.asList(domains).contains("High-Content Screening (HCS)");
    }

    @Override
    public MetadataOptions getMetadataOptions() {
        return this.iReader.getMetadataOptions();
    }

    @Override
    public void setMetadataOptions(MetadataOptions options) {
        this.iReader.setMetadataOptions(options);
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        return this.iReader.getSupportedMetadataLevels();
    }
}

