/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import Ice.Communicator;
import Ice.Current;
import Ice.ObjectAdapter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import loci.common.Location;
import loci.formats.FormatException;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.exclusions.FileExclusion;
import ome.formats.importer.targets.ImportTarget;
import ome.formats.importer.transfers.FileTransfer;
import ome.formats.importer.transfers.TransferState;
import ome.formats.importer.transfers.UploadFileTransfer;
import ome.formats.importer.util.ErrorHandler;
import ome.formats.importer.util.ProportionalTimeEstimatorImpl;
import ome.formats.importer.util.TimeEstimator;
import ome.services.blitz.repo.path.ClientFilePathTransformer;
import ome.services.blitz.repo.path.FilePathRestrictionInstance;
import ome.services.blitz.repo.path.FilePathRestrictions;
import ome.services.blitz.repo.path.MakePathComponentSafe;
import ome.services.blitz.util.ChecksumAlgorithmMapper;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import ome.util.checksum.ChecksumType;
import omero.ChecksumValidationException;
import omero.RLong;
import omero.ServerError;
import omero.api.IMetadataPrx;
import omero.api.RawFileStorePrx;
import omero.api.ServiceFactoryPrx;
import omero.client;
import omero.cmd.CmdCallbackI;
import omero.cmd.ERR;
import omero.cmd.HandlePrx;
import omero.cmd.Response;
import omero.cmd.Status;
import omero.grid.ImportProcessPrx;
import omero.grid.ImportRequest;
import omero.grid.ImportResponse;
import omero.grid.ImportSettings;
import omero.grid.ManagedRepositoryPrx;
import omero.grid.ManagedRepositoryPrxHelper;
import omero.grid.RepositoryMap;
import omero.grid.RepositoryPrx;
import omero.model.Annotation;
import omero.model.ChecksumAlgorithm;
import omero.model.Fileset;
import omero.model.FilesetI;
import omero.model.IObject;
import omero.model.OriginalFile;
import omero.model.Pixels;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportLibrary
implements IObservable {
    private static Logger log = LoggerFactory.getLogger(ImportLibrary.class);
    private static final ChecksumProviderFactory checksumProviderFactory = new ChecksumProviderFactoryImpl();
    private static final ImmutableList<ChecksumAlgorithm> availableChecksumAlgorithms;
    private final ArrayList<IObserver> observers = new ArrayList();
    private final OMEROMetadataStoreClient store;
    private final ManagedRepositoryPrx repo;
    private final ServiceFactoryPrx sf;
    private final FileTransfer transfer;
    private final List<FileExclusion> exclusions = new ArrayList<FileExclusion>();
    private final int minutesToWait;
    private final ObjectAdapter oa;
    private final String category;

    public ImportLibrary(OMEROMetadataStoreClient client2, OMEROWrapper reader) {
        this(client2, reader, new UploadFileTransfer());
    }

    public ImportLibrary(OMEROMetadataStoreClient client2, OMEROWrapper reader, FileTransfer transfer) {
        this(client2, reader, transfer, -1);
    }

    public ImportLibrary(OMEROMetadataStoreClient client2, OMEROWrapper reader, FileTransfer transfer, int minutesToWait) {
        this(client2, reader, transfer, null, -1);
    }

    public ImportLibrary(OMEROMetadataStoreClient client2, OMEROWrapper reader, FileTransfer transfer, List<FileExclusion> exclusions, int minutesToWait) {
        if (client2 == null || reader == null) {
            throw new NullPointerException("All arguments to ImportLibrary() must be non-null.");
        }
        this.store = client2;
        this.transfer = transfer;
        if (exclusions != null) {
            this.exclusions.addAll(exclusions);
        }
        this.minutesToWait = minutesToWait;
        this.repo = this.lookupManagedRepository();
        this.sf = this.store.getServiceFactory();
        this.oa = this.sf.ice_getConnection().getAdapter();
        Communicator ic = this.oa.getCommunicator();
        this.category = client.getRouter(ic).getCategoryForClient();
    }

    @Override
    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }

    public boolean importCandidates(ImportConfig config, ImportCandidates candidates) {
        List<ImportContainer> containers = candidates.getContainers();
        if (containers != null) {
            int numDone = 0;
            for (int index = 0; index < containers.size(); ++index) {
                ImportContainer ic = containers.get(index);
                ImportTarget target = config.getTarget();
                if (target != null) {
                    try {
                        IObject obj = target.load(this.store, ic);
                        if (!(obj instanceof Annotation)) {
                            ic.setTarget(obj);
                        } else {
                            ic.getCustomAnnotationList().add((Annotation)obj);
                        }
                    }
                    catch (Exception e) {
                        log.error("Could not load target: {}", (Object)target);
                        throw new RuntimeException("Failed to load target", e);
                    }
                }
                if (config.checksumAlgorithm.get() != null) {
                    ic.setChecksumAlgorithm((String)config.checksumAlgorithm.get());
                }
                try {
                    this.importImage(ic, index, numDone, containers.size());
                    ++numDone;
                    continue;
                }
                catch (Throwable t) {
                    String message = "Error on import";
                    if (t instanceof ServerError) {
                        ServerError se = (ServerError)t;
                        if (StringUtils.isNotBlank(se.message)) {
                            message = message + ": " + se.message;
                        }
                    }
                    log.error(message, t);
                    if (!((Boolean)config.contOnError.get()).booleanValue()) {
                        log.info("Exiting on error");
                        return false;
                    }
                    log.info("Continuing after error");
                }
            }
        }
        return true;
    }

    public List<String> deleteFilesFromRepository(ImportContainer container) throws ServerError {
        this.checkManagedRepo();
        return null;
    }

    public ImportProcessPrx createImport(ImportContainer container) throws ServerError, IOException {
        this.checkManagedRepo();
        String[] usedFiles = container.getUsedFiles();
        File target = container.getFile();
        if (log.isDebugEnabled()) {
            log.debug("Main file: " + target.getAbsolutePath());
            log.debug("Used files before:");
            for (String f : usedFiles) {
                log.debug(f);
            }
        }
        this.notifyObservers(new ImportEvent.FILESET_UPLOAD_PREPARATION(null, 0, usedFiles.length, null, null, null));
        FilePathRestrictions portableRequiredRules = FilePathRestrictionInstance.getFilePathRestrictions(FilePathRestrictionInstance.WINDOWS_REQUIRED, FilePathRestrictionInstance.UNIX_REQUIRED);
        ClientFilePathTransformer sanitizer = new ClientFilePathTransformer(new MakePathComponentSafe(portableRequiredRules));
        ImportSettings settings = new ImportSettings();
        FilesetI fs = new FilesetI();
        container.fillData(settings, fs, sanitizer, this.transfer);
        String caStr = container.getChecksumAlgorithm();
        if (caStr != null) {
            settings.checksumAlgorithm = ChecksumAlgorithmMapper.getChecksumAlgorithm(caStr);
        } else {
            settings.checksumAlgorithm = this.repo.suggestChecksumAlgorithm(availableChecksumAlgorithms);
            if (settings.checksumAlgorithm == null) {
                throw new RuntimeException("no supported checksum algorithm negotiated with server");
            }
        }
        return this.repo.importFileset(fs, settings);
    }

    public List<String> uploadFilesToRepository(String[] srcFiles, ImportProcessPrx proc) {
        byte[] buf = new byte[this.store.getDefaultBlockSize()];
        int fileTotal = srcFiles.length;
        ArrayList<String> checksums = new ArrayList<String>(fileTotal);
        ProportionalTimeEstimatorImpl estimator = new ProportionalTimeEstimatorImpl(10000L);
        log.debug("Used files created:");
        for (int i = 0; i < fileTotal; ++i) {
            try {
                checksums.add(this.uploadFile(proc, srcFiles, i, checksumProviderFactory, estimator, buf));
                continue;
            }
            catch (ServerError e) {
                log.error("Server error uploading file.", e);
                break;
            }
            catch (IOException e) {
                log.error("I/O error uploading file.", e);
                break;
            }
        }
        return checksums;
    }

    public String uploadFile(ImportProcessPrx proc, String[] srcFiles, int index, TimeEstimator estimator) throws ServerError, IOException {
        byte[] buf = new byte[this.store.getDefaultBlockSize()];
        return this.uploadFile(proc, srcFiles, index, checksumProviderFactory, estimator, buf);
    }

    public String uploadFile(ImportProcessPrx proc, String[] srcFiles, int index, ChecksumProviderFactory cpf, TimeEstimator estimator, byte[] buf) throws ServerError, IOException {
        ChecksumProvider cp = cpf.getProvider(ChecksumAlgorithmMapper.getChecksumType(proc.getImportSettings().checksumAlgorithm));
        File file2 = new File(Location.getMappedId(srcFiles[index]));
        try {
            return this.transfer.transfer(new TransferState(file2, index, srcFiles.length, proc, this, estimator, cp, buf));
        }
        catch (Exception e) {
            this.notifyObservers(new ErrorHandler.FILE_EXCEPTION(file2.getAbsolutePath(), e, srcFiles, "unknown"));
            this.notifyObservers(new ImportEvent.FILE_UPLOAD_ERROR(file2.getAbsolutePath(), index, srcFiles.length, null, null, e));
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServerError) {
                throw (ServerError)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            String msg = "Unexpected exception thrown!";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pixels> importImage(ImportContainer container, int index, int numDone, int total) throws FormatException, IOException, Throwable {
        HandlePrx handle;
        for (FileExclusion exclusion : this.exclusions) {
            Boolean veto = exclusion.suggestExclusion(this.store.getServiceFactory(), container);
            if (!Boolean.TRUE.equals(veto)) continue;
            this.notifyObservers(new ImportEvent.FILESET_EXCLUSION(container.getFile().getAbsolutePath(), 0, container.getUsedFiles().length));
            return Collections.emptyList();
        }
        ImportProcessPrx proc = this.createImport(container);
        String[] srcFiles = container.getUsedFiles();
        ArrayList<String> checksums = new ArrayList<String>();
        byte[] buf = new byte[this.store.getDefaultBlockSize()];
        ProportionalTimeEstimatorImpl estimator = new ProportionalTimeEstimatorImpl(container.getUsedFilesTotalSize());
        HashMap<Integer, String> failingChecksums = new HashMap();
        this.notifyObservers(new ImportEvent.FILESET_UPLOAD_START(null, index, srcFiles.length, null, null, null));
        for (int i = 0; i < srcFiles.length; ++i) {
            checksums.add(this.uploadFile(proc, srcFiles, i, checksumProviderFactory, estimator, buf));
        }
        try {
            handle = proc.verifyUpload(checksums);
        }
        catch (ChecksumValidationException cve) {
            failingChecksums = cve.failingChecksums;
            throw cve;
        }
        finally {
            try {
                proc.close();
            }
            catch (Exception e) {
                log.warn("Exception while closing proc", e);
            }
            this.notifyObservers(new ImportEvent.FILESET_UPLOAD_END(null, index, srcFiles.length, null, null, srcFiles, checksums, failingChecksums, null));
        }
        ImportCallback cb = null;
        try {
            cb = this.createCallback(proc, handle, container);
            if (this.minutesToWait == 0) {
                log.info("Disconnecting from import process...");
                cb.close(false);
                cb = null;
                handle = null;
                List<Pixels> list = Collections.emptyList();
                return list;
            }
            if (this.minutesToWait < 0) {
                while (!cb.block(5000L)) {
                }
            } else {
                cb.loop(this.minutesToWait * 30, 2000L);
            }
            ImportResponse rsp = cb.getImportResponse();
            if (rsp == null) {
                throw new Exception("Import failure");
            }
            List<Pixels> list = rsp.pixels;
            return list;
        }
        finally {
            if (cb != null) {
                cb.close(true);
            } else if (handle != null) {
                handle.close();
            }
        }
    }

    public ImportCallback createCallback(ImportProcessPrx proc, HandlePrx handle, ImportContainer container) throws ServerError {
        return new ImportCallback(proc, handle, container);
    }

    public ManagedRepositoryPrx lookupManagedRepository() {
        try {
            ManagedRepositoryPrx rv = null;
            ServiceFactoryPrx sf = this.store.getServiceFactory();
            RepositoryMap map = sf.sharedResources().repositories();
            for (int i = 0; i < map.proxies.size(); ++i) {
                RepositoryPrx proxy = map.proxies.get(i);
                if (proxy == null || (rv = ManagedRepositoryPrxHelper.checkedCast(proxy)) == null) continue;
                return rv;
            }
            return null;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    private void checkManagedRepo() {
        if (this.repo == null) {
            throw new RuntimeException("Cannot exclusively use the managed repository.\n\nLikely no ManagedRepositoryPrx is being returned from the server.\nThis could point to a recent server crash. Ask your server administrator\nto check for stale .lock files under the OMERO data directory. This\nis particularly likely on a server using NFS.\n");
        }
    }

    public void clear() {
        try {
            this.store.setGroup(null);
            this.store.setCurrentLogFile(null, null);
            this.store.createRoot();
        }
        catch (Throwable t) {
            log.error("failed to clear metadata store", t);
        }
    }

    public OriginalFile loadOriginalFile(RawFileStorePrx uploader) throws ServerError {
        RLong rid = uploader.getFileId();
        long id = rid.getValue();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("omero.group", "-1");
        return (OriginalFile)this.sf.getQueryService().get("OriginalFile", id, ctx);
    }

    static {
        Set<ChecksumType> availableTypes = checksumProviderFactory.getAvailableTypes();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ChecksumAlgorithm checksumAlgorithm : ChecksumAlgorithmMapper.getAllChecksumAlgorithms()) {
            ChecksumType checksumType = ChecksumAlgorithmMapper.getChecksumType(checksumAlgorithm);
            if (!availableTypes.contains((Object)checksumType)) continue;
            builder.add(checksumAlgorithm);
        }
        availableChecksumAlgorithms = builder.build();
    }

    public class ImportCallback
    extends CmdCallbackI {
        final ImportContainer container;
        final Long logFileId;
        volatile ImportResponse importResponse;

        public ImportCallback(ImportProcessPrx proc, HandlePrx handle, ImportContainer container) throws ServerError {
            super(ImportLibrary.this.oa, ImportLibrary.this.category, handle);
            this.importResponse = null;
            this.container = container;
            this.logFileId = this.loadLogFile();
            this.initializationDone();
            ImportLibrary.this.notifyObservers(new ImportEvent.IMPORT_STARTED(0, this.container, null, null, 0, null, 0, 0, this.logFileId));
        }

        protected Long loadLogFile() throws ServerError {
            ImportRequest req = (ImportRequest)this.handle.getRequest();
            Long fsId = req.activity.getParent().getId().getValue();
            IMetadataPrx metadataService = ImportLibrary.this.sf.getMetadataService();
            List<Long> rootIds = Collections.singletonList(fsId);
            try {
                Map<Long, List<IObject>> logMap = metadataService.loadLogFiles(Fileset.class.getName(), rootIds);
                List<IObject> logs = logMap.get(fsId);
                if (CollectionUtils.isNotEmpty(logs)) {
                    for (IObject log : logs) {
                        Long ofId;
                        if (!(log instanceof OriginalFile) || (ofId = Long.valueOf(log.getId().getValue())) == null) continue;
                        return ofId;
                    }
                }
            }
            catch (ServerError e) {
                log.debug("failed to load log file", e);
            }
            return null;
        }

        @Override
        public void step(int step, int total, Current current) {
            if (step == 1) {
                ImportLibrary.this.notifyObservers(new ImportEvent.METADATA_IMPORTED(0, this.container, null, null, 0, null, step, total, this.logFileId));
            } else if (step == 2) {
                ImportLibrary.this.notifyObservers(new ImportEvent.PIXELDATA_PROCESSED(0, this.container, null, null, 0, null, step, total, this.logFileId));
            } else if (step == 3) {
                ImportLibrary.this.notifyObservers(new ImportEvent.THUMBNAILS_GENERATED(0, this.container, null, null, 0, null, step, total, this.logFileId));
            } else if (step == 4) {
                ImportLibrary.this.notifyObservers(new ImportEvent.METADATA_PROCESSED(0, this.container, null, null, 0, null, step, total, this.logFileId));
            } else if (step == 5) {
                ImportLibrary.this.notifyObservers(new ImportEvent.OBJECTS_RETURNED(0, this.container, null, null, 0, null, step, total, this.logFileId));
            }
        }

        @Override
        public void onFinished(Response rsp, Status status, Current c) {
            this.waitOnInitialization();
            ImportResponse rv = null;
            ImportRequest req = (ImportRequest)this.handle.getRequest();
            Fileset fs = req.activity.getParent();
            if (rsp instanceof ERR) {
                ERR err = (ERR)rsp;
                RuntimeException rt = new RuntimeException(String.format("Failure response on import!\nCategory: %s\nName: %s\nParameters: %s\n", err.category, err.name, err.parameters));
                ImportLibrary.this.notifyObservers(new ErrorHandler.INTERNAL_EXCEPTION(this.container.getFile().getAbsolutePath(), rt, this.container.getUsedFiles(), this.container.getReader()));
            } else if (rsp instanceof ImportResponse) {
                rv = (ImportResponse)rsp;
                if (this.importResponse == null) {
                    ImportLibrary.this.notifyObservers(new ImportEvent.IMPORT_DONE(0, this.container, null, null, 0, null, rv.pixels, fs, rv.objects));
                }
                this.importResponse = rv;
            } else {
                RuntimeException rt = new RuntimeException("Unknown response: " + rsp);
                ImportLibrary.this.notifyObservers(new ErrorHandler.INTERNAL_EXCEPTION(this.container.getFile().getAbsolutePath(), rt, this.container.getUsedFiles(), this.container.getReader()));
            }
            this.onFinishedDone();
        }

        public ImportResponse getImportResponse() {
            this.waitOnFinishedDone();
            return this.importResponse;
        }
    }
}

