/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import omero.model.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFixture {
    Logger log = LoggerFactory.getLogger(ImportFixture.class);
    private OMEROMetadataStoreClient store;
    private OMEROWrapper reader;
    private ImportLibrary library;
    private Map<File, Dataset> fads = new HashMap<File, Dataset>();

    public ImportFixture(OMEROMetadataStoreClient store, OMEROWrapper reader) {
        this.store = store;
        this.reader = reader;
    }

    public ImportFixture put(File file2, Dataset ds) {
        if (file2 == null || ds == null) {
            throw new RuntimeException("Arguments cannot be null.");
        }
        this.fads.put(file2, ds);
        return this;
    }

    public ImportFixture putAll(Map<File, Dataset> map) {
        for (File f : map.keySet()) {
            this.put(f, map.get(f));
        }
        return this;
    }

    public void setUp() throws Exception {
        this.library = new ImportLibrary(this.store, this.reader);
    }

    public void tearDown() {
        this.fads = null;
        this.store = null;
        this.library = null;
        try {
            this.reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.reader = null;
        }
    }

    public void doImport() throws Throwable {
        for (File file2 : this.fads.keySet()) {
            ImportContainer ic = new ImportContainer(file2, this.fads.get(file2), null, null, null, null);
            this.library.importImage(ic, 0, 0, 1);
        }
    }
}

