/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.transfers.FileTransfer;
import ome.formats.importer.transfers.UploadFileTransfer;
import ome.services.blitz.repo.path.ClientFilePathTransformer;
import ome.services.blitz.repo.path.FsFile;
import omero.grid.ImportSettings;
import omero.model.Annotation;
import omero.model.BooleanAnnotationI;
import omero.model.CommentAnnotationI;
import omero.model.Fileset;
import omero.model.FilesetEntryI;
import omero.model.IObject;
import omero.model.NamedValue;
import omero.model.UploadJobI;
import omero.rtypes;

public class ImportContainer {
    private String reader;
    private String[] usedFiles;
    private long usedFilesTotalSize;
    private Boolean isSPW;
    private File file;
    private Double[] userPixels;
    private String userSpecifiedName;
    private String userSpecifiedDescription;
    private boolean doThumbnails = true;
    private boolean noStatsInfo = false;
    private List<Annotation> customAnnotationList;
    private IObject target;
    private String checksumAlgorithm;
    private ImportConfig config;

    public ImportContainer(File file2, IObject target, Double[] userPixels, String reader, String[] usedFiles, Boolean isSPW) {
        this(null, file2, target, userPixels, reader, usedFiles, isSPW);
    }

    public ImportContainer(ImportConfig config, File file2, IObject target, Double[] userPixels, String reader, String[] usedFiles, Boolean isSPW) {
        this.config = config;
        this.file = file2;
        this.target = target;
        this.userPixels = userPixels;
        this.reader = reader;
        this.usedFiles = usedFiles;
        this.isSPW = isSPW;
    }

    public boolean getDoThumbnails() {
        return this.doThumbnails;
    }

    public void setDoThumbnails(boolean v) {
        this.doThumbnails = v;
    }

    public boolean getNoStatsInfo() {
        return this.noStatsInfo;
    }

    public void setNoStatsInfo(boolean v) {
        this.noStatsInfo = v;
    }

    public String getUserSpecifiedName() {
        return this.userSpecifiedName;
    }

    public void setUserSpecifiedName(String v) {
        this.userSpecifiedName = v;
    }

    public String getUserSpecifiedDescription() {
        return this.userSpecifiedDescription;
    }

    public void setUserSpecifiedDescription(String v) {
        this.userSpecifiedDescription = v;
    }

    public List<Annotation> getCustomAnnotationList() {
        return this.customAnnotationList;
    }

    public void setCustomAnnotationList(List<Annotation> v) {
        this.customAnnotationList = v;
    }

    public String getReader() {
        return this.reader;
    }

    public void setReader(String reader) {
        this.reader = reader;
    }

    public String[] getUsedFiles() {
        return this.usedFiles;
    }

    public void setUsedFiles(String[] usedFiles) {
        this.usedFiles = usedFiles;
    }

    public long getUsedFilesTotalSize() {
        return this.usedFilesTotalSize;
    }

    public Boolean getIsSPW() {
        return this.isSPW;
    }

    public void setIsSPW(Boolean isSPW) {
        this.isSPW = isSPW;
    }

    public File getFile() {
        return this.file;
    }

    void setFile(File file2) {
        this.file = file2;
    }

    public IObject getTarget() {
        return this.target;
    }

    public void setTarget(IObject obj) {
        this.target = obj;
    }

    public Double[] getUserPixels() {
        return this.userPixels;
    }

    public void setUserPixels(Double[] userPixels) {
        this.userPixels = userPixels;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public void setChecksumAlgorithm(String ca) {
        this.checksumAlgorithm = ca;
    }

    public void fillData(ImportSettings settings, Fileset fs, ClientFilePathTransformer sanitizer) throws IOException {
        this.fillData(this.config, settings, fs, sanitizer, null);
    }

    public void fillData(ImportSettings settings, Fileset fs, ClientFilePathTransformer sanitizer, FileTransfer transfer) throws IOException {
        this.fillData(this.config, settings, fs, sanitizer, transfer);
    }

    public void fillData(ImportConfig config, ImportSettings settings, Fileset fs, ClientFilePathTransformer sanitizer) throws IOException {
        this.fillData(config, settings, fs, sanitizer, null);
    }

    public void fillData(ImportConfig config, ImportSettings settings, Fileset fs, ClientFilePathTransformer sanitizer, FileTransfer transfer) throws IOException {
        if (config == null) {
            config = new ImportConfig();
        }
        settings.doThumbnails = rtypes.rbool(this.getDoThumbnails());
        settings.noStatsInfo = rtypes.rbool(this.getNoStatsInfo());
        settings.userSpecifiedTarget = this.getTarget();
        settings.userSpecifiedName = this.getUserSpecifiedName() == null ? null : rtypes.rstring(this.getUserSpecifiedName());
        settings.userSpecifiedDescription = this.getUserSpecifiedDescription() == null ? null : rtypes.rstring(this.getUserSpecifiedDescription());
        ArrayList<Annotation> arrayList = settings.userSpecifiedAnnotationList = this.getCustomAnnotationList() == null ? null : new ArrayList<Annotation>(this.getCustomAnnotationList());
        if (((Boolean)config.autoClose.get()).booleanValue()) {
            BooleanAnnotationI ba = new BooleanAnnotationI();
            ba.setBoolValue(rtypes.rbool(true));
            ba.setNs(rtypes.rstring("openmicroscopy.org/omero/import/autoClose"));
            settings.userSpecifiedAnnotationList.add(ba);
        }
        if (this.getUserPixels() != null) {
            Object[] source = this.getUserPixels();
            double[] target = new double[source.length];
            for (int i = 0; i < source.length; ++i) {
                if (source[i] == null) {
                    target = null;
                    break;
                }
                target[i] = (Double)source[i];
            }
            settings.userSpecifiedPixels = target;
        }
        for (String usedFile : this.getUsedFiles()) {
            FilesetEntryI entry = new FilesetEntryI();
            FsFile fsPath = sanitizer.getFsFileFromClientFile(new File(usedFile), Integer.MAX_VALUE);
            entry.setClientPath(rtypes.rstring(fsPath.toString()));
            fs.addFilesetEntry(entry);
        }
        if (transfer != null && !transfer.getClass().equals(UploadFileTransfer.class)) {
            String type = transfer.getClass().getName();
            CommentAnnotationI transferAnnotation = new CommentAnnotationI();
            transferAnnotation.setNs(rtypes.rstring("openmicroscopy.org/omero/import/fileTransfer"));
            transferAnnotation.setTextValue(rtypes.rstring(type));
            fs.linkAnnotation(transferAnnotation);
        }
        ArrayList<NamedValue> clientVersionInfo = new ArrayList<NamedValue>();
        clientVersionInfo.add(new NamedValue(ImportConfig.VersionInfo.BIO_FORMATS_READER.key, this.reader));
        config.fillVersionInfo(clientVersionInfo);
        UploadJobI upload = new UploadJobI();
        upload.setVersionInfo(clientVersionInfo);
        fs.linkJob(upload);
    }

    public void updateUsedFilesTotalSize() {
        this.usedFilesTotalSize = 0L;
        for (String filePath : this.usedFiles) {
            this.usedFilesTotalSize += new File(filePath).length();
        }
    }
}

