/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import ome.model.IEnum;
import ome.model.IObject;
import ome.model.acquisition.Detector;
import ome.model.acquisition.DetectorSettings;
import ome.model.acquisition.Dichroic;
import ome.model.acquisition.Filter;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.ImagingEnvironment;
import ome.model.acquisition.Instrument;
import ome.model.acquisition.Laser;
import ome.model.acquisition.LightPath;
import ome.model.acquisition.LightSettings;
import ome.model.acquisition.LightSource;
import ome.model.acquisition.Microscope;
import ome.model.acquisition.OTF;
import ome.model.acquisition.Objective;
import ome.model.acquisition.ObjectiveSettings;
import ome.model.acquisition.StageLabel;
import ome.model.annotations.Annotation;
import ome.model.annotations.FileAnnotation;
import ome.model.containers.Dataset;
import ome.model.containers.Folder;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.core.PlaneInfo;
import ome.model.enums.Format;
import ome.model.experiment.Experiment;
import ome.model.experiment.MicrobeamManipulation;
import ome.model.fs.Fileset;
import ome.model.fs.FilesetJobLink;
import ome.model.roi.Roi;
import ome.model.roi.Shape;
import ome.model.screen.Plate;
import ome.model.screen.PlateAcquisition;
import ome.model.screen.Reagent;
import ome.model.screen.Screen;
import ome.model.screen.Well;
import ome.model.screen.WellSample;
import ome.model.stats.StatsInfo;
import ome.system.ServiceFactory;
import ome.util.LSID;
import ome.util.SqlAction;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMEROMetadataStore {
    private static String[] DOMAINS = new String[]{"jpeg", "png", "bmp", "gif", "tiff", "avi"};
    private static Logger log = LoggerFactory.getLogger(OMEROMetadataStore.class);
    private ServiceFactory sf;
    private SqlAction sql;
    private Map<Integer, Image> imageList = new LinkedHashMap<Integer, Image>();
    private Map<Integer, Pixels> pixelsList = new LinkedHashMap<Integer, Pixels>();
    private Map<Integer, Screen> screenList = new LinkedHashMap<Integer, Screen>();
    private Map<Integer, Plate> plateList = new LinkedHashMap<Integer, Plate>();
    private Map<Integer, Roi> roiList = new LinkedHashMap<Integer, Roi>();
    private Map<Integer, Map<Integer, Well>> wellList = new LinkedHashMap<Integer, Map<Integer, Well>>();
    private Map<Integer, Instrument> instrumentList = new LinkedHashMap<Integer, Instrument>();
    private Map<Integer, Experiment> experimentList = new LinkedHashMap<Integer, Experiment>();
    private Map<Integer, Folder> folderList = new LinkedHashMap<Integer, Folder>();
    private Map<Instrument, Map<Integer, OTF>> otfList = new LinkedHashMap<Instrument, Map<Integer, OTF>>();
    private Map<LSID, IObject> lsidMap = new HashMap<LSID, IObject>();

    public void updateObject(String lsid, IObject sourceObject, Map<String, Integer> indexes) {
        this.lsidMap.put(new LSID(lsid), sourceObject);
        if (sourceObject instanceof Image) {
            this.handle(lsid, (Image)sourceObject, indexes);
        } else if (sourceObject instanceof StageLabel) {
            this.handle(lsid, (StageLabel)sourceObject, indexes);
        } else if (sourceObject instanceof Pixels) {
            this.handle(lsid, (Pixels)sourceObject, indexes);
        } else if (sourceObject instanceof Channel) {
            this.handle(lsid, (Channel)sourceObject, indexes);
        } else if (sourceObject instanceof LogicalChannel) {
            this.handle(lsid, (LogicalChannel)sourceObject, indexes);
        } else if (sourceObject instanceof PlaneInfo) {
            this.handle(lsid, (PlaneInfo)sourceObject, indexes);
        } else if (sourceObject instanceof Instrument) {
            this.handle(lsid, (Instrument)sourceObject, indexes);
        } else if (sourceObject instanceof Microscope) {
            this.handle(lsid, (Microscope)sourceObject, indexes);
        } else if (sourceObject instanceof Objective) {
            this.handle(lsid, (Objective)sourceObject, indexes);
        } else if (sourceObject instanceof Detector) {
            this.handle(lsid, (Detector)sourceObject, indexes);
        } else if (sourceObject instanceof Dichroic) {
            this.handle(lsid, (Dichroic)sourceObject, indexes);
        } else if (sourceObject instanceof Filter) {
            this.handle(lsid, (Filter)sourceObject, indexes);
        } else if (sourceObject instanceof FilterSet) {
            this.handle(lsid, (FilterSet)sourceObject, indexes);
        } else if (sourceObject instanceof LightSource) {
            this.handle(lsid, (LightSource)sourceObject, indexes);
        } else if (sourceObject instanceof OTF) {
            this.handle(lsid, (OTF)sourceObject, indexes);
        } else if (sourceObject instanceof ImagingEnvironment) {
            this.handle(lsid, (ImagingEnvironment)sourceObject, indexes);
        } else if (sourceObject instanceof DetectorSettings) {
            this.handle(lsid, (DetectorSettings)sourceObject, indexes);
        } else if (sourceObject instanceof LightSettings) {
            this.handle(lsid, (LightSettings)sourceObject, indexes);
        } else if (sourceObject instanceof ObjectiveSettings) {
            this.handle(lsid, (ObjectiveSettings)sourceObject, indexes);
        } else if (sourceObject instanceof LightPath) {
            this.handle(lsid, (LightPath)sourceObject, indexes);
        } else if (sourceObject instanceof Screen) {
            this.handle(lsid, (Screen)sourceObject, indexes);
        } else if (sourceObject instanceof Plate) {
            this.handle(lsid, (Plate)sourceObject, indexes);
        } else if (sourceObject instanceof PlateAcquisition) {
            this.handle(lsid, (PlateAcquisition)sourceObject, indexes);
        } else if (sourceObject instanceof Well) {
            this.handle(lsid, (Well)sourceObject, indexes);
        } else if (sourceObject instanceof Reagent) {
            this.handle(lsid, (Reagent)sourceObject, indexes);
        } else if (sourceObject instanceof WellSample) {
            this.handle(lsid, (WellSample)sourceObject, indexes);
        } else if (sourceObject instanceof OriginalFile) {
            this.handle(lsid, (OriginalFile)sourceObject, indexes);
        } else if (sourceObject instanceof Annotation) {
            this.handle(lsid, (Annotation)sourceObject, indexes);
        } else if (sourceObject instanceof Experiment) {
            this.handle(lsid, (Experiment)sourceObject, indexes);
        } else if (sourceObject instanceof MicrobeamManipulation) {
            this.handle(lsid, (MicrobeamManipulation)sourceObject, indexes);
        } else if (sourceObject instanceof Roi) {
            this.handle(lsid, (Roi)sourceObject, indexes);
        } else if (sourceObject instanceof Shape) {
            this.handle(lsid, (Shape)sourceObject, indexes);
        } else if (sourceObject instanceof Folder) {
            this.handle(lsid, (Folder)sourceObject, indexes);
        } else {
            throw new ApiUsageException("Missing object handler for object type: " + sourceObject.getClass());
        }
    }

    public void updateReferences(Map<String, String[]> referenceCache) {
        for (String target : referenceCache.keySet()) {
            for (String reference : referenceCache.get(target)) {
                int colonIndex;
                LSID targetLSID = new LSID(target);
                IObject targetObject = this.lsidMap.get(targetLSID);
                LSID referenceLSID = new LSID(reference);
                IObject referenceObject = this.lsidMap.get(new LSID(this.stripCustomSuffix(reference)));
                log.debug(String.format("Updating reference handler for %s(%s) --> %s(%s).", reference, referenceObject, target, targetObject));
                if (targetObject instanceof DetectorSettings) {
                    if (referenceObject instanceof Detector) {
                        this.handleReference((DetectorSettings)targetObject, (Detector)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Image) {
                    if (referenceObject instanceof Instrument) {
                        this.handleReference((Image)targetObject, (Instrument)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Image)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Roi) {
                        this.handleReference((Image)targetObject, (Roi)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Experiment) {
                        this.handleReference((Image)targetObject, (Experiment)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof MicrobeamManipulation) {
                        this.handleReference((Image)targetObject, (MicrobeamManipulation)referenceObject);
                        continue;
                    }
                    if (referenceLSID.toString().contains("DatasetI")) {
                        colonIndex = reference.indexOf(":");
                        long datasetId = Long.parseLong(reference.substring(colonIndex + 1));
                        referenceObject = new Dataset(datasetId, false);
                        this.handleReference((Image)targetObject, (Dataset)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof PlaneInfo) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((PlaneInfo)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof LightSource) {
                    if (referenceObject instanceof LightSource) {
                        this.handleReference((LightSource)targetObject, (LightSource)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((LightSource)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Detector) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Detector)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Dichroic) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Dichroic)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Filter) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Filter)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Instrument) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Instrument)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Objective) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Objective)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Shape) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Shape)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof LightSettings) {
                    if (referenceObject instanceof LightSource) {
                        this.handleReference((LightSettings)targetObject, (LightSource)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof LightPath) {
                    if (referenceObject instanceof Dichroic) {
                        this.handleReference((LightPath)targetObject, (Dichroic)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Filter) {
                        this.handleReference((LightPath)targetObject, (Filter)referenceObject, referenceLSID);
                        continue;
                    }
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((LightPath)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Channel) {
                    if (referenceObject instanceof OTF) {
                        this.handleReference((Channel)targetObject, (OTF)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Channel)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof LogicalChannel) {
                    if (referenceObject instanceof Filter) {
                        this.handleReference((LogicalChannel)targetObject, (Filter)referenceObject, referenceLSID);
                        continue;
                    }
                    if (referenceObject instanceof FilterSet) {
                        this.handleReference((LogicalChannel)targetObject, (FilterSet)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof OTF) {
                    if (referenceObject instanceof Objective) {
                        this.handleReference((OTF)targetObject, (Objective)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof FilterSet) {
                        this.handleReference((OTF)targetObject, (FilterSet)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof ObjectiveSettings) {
                    if (referenceObject instanceof Objective) {
                        this.handleReference((ObjectiveSettings)targetObject, (Objective)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof WellSample) {
                    if (referenceObject instanceof Image) {
                        this.handleReference((WellSample)targetObject, (Image)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof PlateAcquisition) {
                    if (referenceObject instanceof WellSample) {
                        this.handleReference((PlateAcquisition)targetObject, (WellSample)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((PlateAcquisition)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Pixels) {
                    if (referenceObject instanceof OriginalFile) {
                        this.handleReference((Pixels)targetObject, (OriginalFile)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof FilterSet) {
                    if (referenceObject instanceof Filter) {
                        this.handleReference((FilterSet)targetObject, (Filter)referenceObject, referenceLSID);
                        continue;
                    }
                    if (referenceObject instanceof Dichroic) {
                        this.handleReference((FilterSet)targetObject, (Dichroic)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Plate) {
                    if (referenceLSID.toString().contains("ScreenI")) {
                        colonIndex = reference.indexOf(":");
                        long screenId = Long.parseLong(reference.substring(colonIndex + 1));
                        referenceObject = new Screen(screenId, false);
                        this.handleReference((Plate)targetObject, (Screen)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Screen) {
                        this.handleReference((Plate)targetObject, (Screen)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Plate)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Screen) {
                    if (referenceObject instanceof Plate) {
                        this.handleReference((Screen)targetObject, (Plate)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Screen)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Well) {
                    if (referenceObject instanceof Reagent) {
                        this.handleReference((Well)targetObject, (Reagent)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Reagent) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Reagent)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof FileAnnotation) {
                    if (referenceObject instanceof OriginalFile) {
                        this.handleReference((FileAnnotation)targetObject, (OriginalFile)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Annotation) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Annotation)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof MicrobeamManipulation) {
                    if (referenceObject instanceof Roi) {
                        this.handleReference((MicrobeamManipulation)targetObject, (Roi)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Roi) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Roi)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof PlateAcquisition) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((PlateAcquisition)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                } else if (targetObject instanceof Folder) {
                    if (referenceObject instanceof Annotation) {
                        this.handleReference((Folder)targetObject, (Annotation)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Folder) {
                        this.handleReference((Folder)targetObject, (Folder)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Image) {
                        this.handleReference((Folder)targetObject, (Image)referenceObject);
                        continue;
                    }
                    if (referenceObject instanceof Roi) {
                        this.handleReference((Folder)targetObject, (Roi)referenceObject);
                        continue;
                    }
                }
                throw new ApiUsageException(String.format("Missing reference handler for %s(%s) --> %s(%s) reference.", reference, referenceObject, target, targetObject));
            }
        }
    }

    private String stripCustomSuffix(String LSID2) {
        if (LSID2.endsWith("OMERO_EMISSION_FILTER") || LSID2.endsWith("OMERO_EXCITATION_FILTER")) {
            return LSID2.substring(0, LSID2.lastIndexOf(58));
        }
        return LSID2;
    }

    private void handle(String LSID2, Image sourceObject, Map<String, Integer> indexes) {
        int imageIndex = indexes.get("imageIndex");
        this.imageList.put(imageIndex, sourceObject);
    }

    private void handle(String LSID2, Pixels sourceObject, Map<String, Integer> indexes) {
        int imageIndex = indexes.get("imageIndex");
        this.imageList.get(imageIndex).addPixels(sourceObject);
    }

    private void handle(String LSID2, Channel sourceObject, Map<String, Integer> indexes) {
        Pixels p = this.getPixels(indexes.get("imageIndex"), 0);
        p.addChannel(sourceObject);
    }

    private void handle(String LSID2, LogicalChannel sourceObject, Map<String, Integer> indexes) {
        Channel c = this.getChannel(indexes.get("imageIndex"), indexes.get("channelIndex"));
        c.setLogicalChannel(sourceObject);
    }

    private void handle(String LSID2, PlaneInfo sourceObject, Map<String, Integer> indexes) {
        int imageIndex = indexes.get("imageIndex");
        Pixels p = this.imageList.get(imageIndex).getPrimaryPixels();
        p.addPlaneInfo(sourceObject);
    }

    private void handle(String LSID2, Instrument sourceObject, Map<String, Integer> indexes) {
        int instrumentIndex = indexes.get("instrumentIndex");
        this.instrumentList.put(instrumentIndex, sourceObject);
    }

    private void handle(String LSID2, Microscope sourceObject, Map<String, Integer> indexes) {
        int instrumentIndex = indexes.get("instrumentIndex");
        this.instrumentList.get(instrumentIndex).setMicroscope(sourceObject);
    }

    private void handle(String LSID2, StageLabel sourceObject, Map<String, Integer> indexes) {
        Image i = this.getImage(indexes.get("imageIndex"));
        i.setStageLabel(sourceObject);
    }

    private void handle(String LSID2, Objective sourceObject, Map<String, Integer> indexes) {
        Instrument i = this.getInstrument(indexes.get("instrumentIndex"));
        i.addObjective(sourceObject);
    }

    private void handle(String LSID2, Detector sourceObject, Map<String, Integer> indexes) {
        Instrument i = this.getInstrument(indexes.get("instrumentIndex"));
        i.addDetector(sourceObject);
    }

    private void handle(String LSID2, LightSource sourceObject, Map<String, Integer> indexes) {
        Instrument i = this.instrumentList.get(indexes.get("instrumentIndex"));
        i.addLightSource(sourceObject);
    }

    private void handle(String LSID2, OTF sourceObject, Map<String, Integer> indexes) {
        Instrument i = this.instrumentList.get(indexes.get("instrumentIndex"));
        i.addOTF(sourceObject);
        Map<Integer, OTF> map = this.otfList.get(i);
        if (map == null) {
            map = new HashMap<Integer, OTF>();
            this.otfList.put(i, map);
        }
        map.put(indexes.get("otfIndex"), sourceObject);
    }

    private void handle(String LSID2, Dichroic sourceObject, Map<String, Integer> indexes) {
        Instrument i = this.instrumentList.get(indexes.get("instrumentIndex"));
        i.addDichroic(sourceObject);
    }

    private void handle(String LSID2, Filter sourceObject, Map<String, Integer> indexes) {
        Instrument i = this.instrumentList.get(indexes.get("instrumentIndex"));
        i.addFilter(sourceObject);
    }

    private void handle(String LSID2, FilterSet sourceObject, Map<String, Integer> indexes) {
        Instrument i = this.instrumentList.get(indexes.get("instrumentIndex"));
        i.addFilterSet(sourceObject);
    }

    private void handle(String LSID2, ImagingEnvironment sourceObject, Map<String, Integer> indexes) {
        Image i = this.imageList.get(indexes.get("imageIndex"));
        i.setImagingEnvironment(sourceObject);
    }

    private void handle(String LSID2, DetectorSettings sourceObject, Map<String, Integer> indexes) {
        LogicalChannel lc = this.getLogicalChannel(indexes.get("imageIndex"), indexes.get("channelIndex"));
        lc.setDetectorSettings(sourceObject);
    }

    private void handle(String LSID2, LightSettings sourceObject, Map<String, Integer> indexes) {
        Integer imageIndex = indexes.get("imageIndex");
        Integer channelIndex = indexes.get("channelIndex");
        Integer experimentIndex = indexes.get("experimentIndex");
        Integer microbeamManipulationIndex = indexes.get("microbeamManipulationIndex");
        if (experimentIndex != null) {
            Experiment e = this.experimentList.get(experimentIndex);
            Iterator<MicrobeamManipulation> iter = e.iterateMicrobeamManipulation();
            for (int i = 0; i < e.sizeOfMicrobeamManipulation(); ++i) {
                MicrobeamManipulation mm = iter.next();
                if (i != microbeamManipulationIndex) continue;
                mm.addLightSettings(sourceObject);
            }
        } else {
            LogicalChannel lc = this.getLogicalChannel(imageIndex, channelIndex);
            lc.setLightSourceSettings(sourceObject);
        }
    }

    private void handle(String LSID2, ObjectiveSettings sourceObject, Map<String, Integer> indexes) {
        Integer instrumentIndex = indexes.get("instrumentIndex");
        Integer otfIndex = indexes.get("otfIndex");
        Integer imageIndex = indexes.get("imageIndex");
        if (instrumentIndex != null && otfIndex != null) {
            OTF o = this.getOTF(instrumentIndex, otfIndex);
            o.setObjective(sourceObject.getObjective());
        } else {
            Image i = this.getImage(imageIndex);
            i.setObjectiveSettings(sourceObject);
        }
    }

    private void handle(String LSID2, LightPath sourceObject, Map<String, Integer> indexes) {
        Channel c = this.getChannel(indexes.get("imageIndex"), indexes.get("channelIndex"));
        c.getLogicalChannel().setLightPath(sourceObject);
    }

    private void handle(String LSID2, Plate sourceObject, Map<String, Integer> indexes) {
        int plateIndex = indexes.get("plateIndex");
        this.wellList.put(plateIndex, new LinkedHashMap());
        this.plateList.put(plateIndex, sourceObject);
    }

    private void handle(String LSID2, Well sourceObject, Map<String, Integer> indexes) {
        int plateIndex = indexes.get("plateIndex");
        int wellIndex = indexes.get("wellIndex");
        this.getPlate(plateIndex).addWell(sourceObject);
        this.wellList.get(plateIndex).put(wellIndex, sourceObject);
    }

    private void handle(String LSID2, Screen sourceObject, Map<String, Integer> indexes) {
        int screenIndex = indexes.get("screenIndex");
        this.screenList.put(screenIndex, sourceObject);
    }

    private void handle(String LSID2, Reagent sourceObject, Map<String, Integer> indexes) {
        int screenIndex = indexes.get("screenIndex");
        this.getScreen(screenIndex).addReagent(sourceObject);
    }

    private void handle(String LSID2, WellSample sourceObject, Map<String, Integer> indexes) {
        int plateIndex = indexes.get("plateIndex");
        int wellIndex = indexes.get("wellIndex");
        Well w = this.getWell(plateIndex, wellIndex);
        w.addWellSample(sourceObject);
    }

    private void handle(String LSID2, Roi sourceObject, Map<String, Integer> indexes) {
        this.roiList.put(indexes.get("roiIndex"), sourceObject);
    }

    private void handle(String LSID2, Shape sourceObject, Map<String, Integer> indexes) {
        int roiIndex = indexes.get("roiIndex");
        Roi r = this.getRoi(roiIndex);
        r.addShape(sourceObject);
    }

    private void handle(String LSID2, OriginalFile sourceObject, Map<String, Integer> indexes) {
    }

    private void handle(String LSID2, Annotation sourceObject, Map<String, Integer> indexes) {
    }

    private void handle(String LSID2, Experiment sourceObject, Map<String, Integer> indexes) {
        int experimentIndex = indexes.get("experimentIndex");
        this.experimentList.put(experimentIndex, sourceObject);
    }

    private void handle(String LSID2, MicrobeamManipulation sourceObject, Map<String, Integer> indexes) {
        int experimentIndex = indexes.get("experimentIndex");
        Experiment e = this.experimentList.get(experimentIndex);
        e.addMicrobeamManipulation(sourceObject);
    }

    private void handle(String LSID2, PlateAcquisition sourceObject, Map<String, Integer> indexes) {
        int plateIndex = indexes.get("plateIndex");
        Plate p = this.getPlate(plateIndex);
        p.addPlateAcquisition(sourceObject);
    }

    private void handle(String LSID2, Folder sourceObject, Map<String, Integer> indexes) {
        int folderIndex = indexes.get("folderIndex");
        this.folderList.put(folderIndex, sourceObject);
    }

    private void handleReference(DetectorSettings target, Detector reference) {
        target.setDetector(reference);
    }

    private void handleReference(Image target, Instrument reference) {
        target.setInstrument(reference);
    }

    private void handleReference(Image target, Dataset reference) {
        target.linkDataset(reference);
    }

    private void handleReference(LightSource target, LightSource reference) {
        Laser laser = (Laser)target;
        laser.setPump(reference);
    }

    private void handleReference(LightSettings target, LightSource reference) {
        target.setLightSource(reference);
    }

    private void handleReference(LightPath target, Dichroic reference) {
        target.setDichroic(reference);
    }

    private void handleReference(LightPath target, Filter reference, LSID referenceLSID) {
        if (referenceLSID.toString().endsWith("OMERO_EMISSION_FILTER")) {
            target.linkEmissionFilter(reference);
        } else if (referenceLSID.toString().endsWith("OMERO_EXCITATION_FILTER")) {
            target.linkExcitationFilter(reference);
        } else {
            throw new ApiUsageException(String.format("Unable to handle LightPath --> Filter reference: %s", referenceLSID));
        }
    }

    private void handleReference(Channel target, OTF reference) {
        target.getLogicalChannel().setOtf(reference);
    }

    private void handleReference(Channel target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(LogicalChannel target, FilterSet reference) {
        target.setFilterSet(reference);
    }

    private void handleReference(LogicalChannel target, Filter reference, LSID referenceLSID) {
        LightPath lightPath = target.getLightPath();
        if (lightPath == null) {
            lightPath = new LightPath();
        }
        target.setLightPath(lightPath);
        if (referenceLSID.toString().endsWith("OMERO_EMISSION_FILTER")) {
            lightPath.linkEmissionFilter(reference);
        } else if (referenceLSID.toString().endsWith("OMERO_EXCITATION_FILTER")) {
            lightPath.linkExcitationFilter(reference);
        } else {
            throw new ApiUsageException(String.format("Unable to handle LogicalChannel --> Filter reference: %s", referenceLSID));
        }
    }

    private void handleReference(OTF target, Objective reference) {
        target.setObjective(reference);
    }

    private void handleReference(OTF target, FilterSet reference) {
        target.setFilterSet(reference);
    }

    private void handleReference(ObjectiveSettings target, Objective reference) {
        target.setObjective(reference);
    }

    private void handleReference(WellSample target, Image reference) {
        reference.addWellSample(target);
    }

    private void handleReference(PlateAcquisition target, WellSample reference) {
        target.addWellSample(reference);
    }

    private void handleReference(PlateAcquisition target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Pixels target, OriginalFile reference) {
        target.linkOriginalFile(reference);
    }

    private void handleReference(FilterSet target, Dichroic reference) {
        target.setDichroic(reference);
    }

    private void handleReference(FilterSet target, Filter reference, LSID referenceLSID) {
        if (referenceLSID.toString().endsWith("OMERO_EMISSION_FILTER")) {
            target.linkEmissionFilter(reference);
        } else if (referenceLSID.toString().endsWith("OMERO_EXCITATION_FILTER")) {
            target.linkExcitationFilter(reference);
        } else {
            throw new ApiUsageException(String.format("Unable to handle FilterSet --> Filter reference: %s", referenceLSID));
        }
    }

    private void handleReference(Image target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Image target, Roi reference) {
        target.addRoi(reference);
    }

    private void handleReference(Image target, Experiment reference) {
        target.setExperiment(reference);
    }

    private void handleReference(Image target, MicrobeamManipulation reference) {
    }

    private void handleReference(Screen target, Plate reference) {
        if (!target.linkedPlateList().contains(reference)) {
            target.linkPlate(reference);
        }
    }

    private void handleReference(Screen target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Plate target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Detector target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Dichroic target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Filter target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Instrument target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(LightPath target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Objective target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Shape target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(LightSource target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Reagent target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Roi target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(PlaneInfo target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Plate target, Screen reference) {
        if (!target.linkedScreenList().contains(reference)) {
            target.linkScreen(reference);
        }
    }

    private void handleReference(Well target, Reagent reference) {
        target.linkReagent(reference);
    }

    private void handleReference(FileAnnotation target, OriginalFile reference) {
        target.setFile(reference);
    }

    private void handleReference(Annotation target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(MicrobeamManipulation target, Roi reference) {
    }

    private void handleReference(Folder target, Annotation reference) {
        target.linkAnnotation(reference);
    }

    private void handleReference(Folder target, Image reference) {
        target.linkImage(reference);
    }

    private void handleReference(Folder target, Folder reference) {
        target.addChildFolders(reference);
    }

    private void handleReference(Folder target, Roi reference) {
        target.linkRoi(reference);
    }

    public IObject getObjectByLSID(LSID lsid) {
        return this.lsidMap.get(lsid);
    }

    private Image getImage(int imageIndex) {
        return this.imageList.get(imageIndex);
    }

    private Pixels getPixels(int imageIndex, int pixelsIndex) {
        return this.getImage(imageIndex).getPixels(pixelsIndex);
    }

    private Instrument getInstrument(int instrumentIndex) {
        return this.instrumentList.get(instrumentIndex);
    }

    private OTF getOTF(int instrumentIndex, int otfIndex) {
        Instrument i = this.getInstrument(instrumentIndex);
        return this.otfList.get(i).get(otfIndex);
    }

    private Channel getChannel(int imageIndex, int channelIndex) {
        return this.getPixels(imageIndex, 0).getChannel(channelIndex);
    }

    private LogicalChannel getLogicalChannel(int imageIndex, int channelIndex) {
        return this.getChannel(imageIndex, channelIndex).getLogicalChannel();
    }

    private Screen getScreen(int screenIndex) {
        return this.screenList.get(screenIndex);
    }

    private Plate getPlate(int plateIndex) {
        return this.plateList.get(plateIndex);
    }

    private Well getWell(int plateIndex, int wellIndex) {
        return this.wellList.get(plateIndex).get(wellIndex);
    }

    private Roi getRoi(int roiIndex) {
        return this.roiList.get(roiIndex);
    }

    private Folder getFolder(int folderIndex) {
        return this.folderList.get(folderIndex);
    }

    public OMEROMetadataStore() {
    }

    public OMEROMetadataStore(ServiceFactory factory, SqlAction sql) throws ValidationException {
        if (factory == null || sql == null) {
            throw new ValidationException("arguments cannot be null");
        }
        this.sf = factory;
        this.sql = sql;
    }

    public void createRoot() {
        this.imageList = new LinkedHashMap<Integer, Image>();
        this.pixelsList = new LinkedHashMap<Integer, Pixels>();
        this.screenList = new LinkedHashMap<Integer, Screen>();
        this.plateList = new LinkedHashMap<Integer, Plate>();
        this.roiList = new LinkedHashMap<Integer, Roi>();
        this.wellList = new LinkedHashMap<Integer, Map<Integer, Well>>();
        this.instrumentList = new LinkedHashMap<Integer, Instrument>();
        this.experimentList = new LinkedHashMap<Integer, Experiment>();
        this.otfList = new LinkedHashMap<Instrument, Map<Integer, OTF>>();
        this.lsidMap = new LinkedHashMap<LSID, IObject>();
    }

    private static boolean compare(IEnum a, IEnum b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getId() == b.getId();
    }

    private static boolean compare(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public void checkAndCollapseGraph() {
        if (this.plateList.size() == 0) {
            return;
        }
        HashSet<ObjectiveSettings> objectiveSettings = new HashSet<ObjectiveSettings>();
        HashSet<LightSettings> lightSettings = new HashSet<LightSettings>();
        HashSet<LightPath> lightPaths = new HashSet<LightPath>();
        HashSet<DetectorSettings> detectorSettings = new HashSet<DetectorSettings>();
        HashSet<LogicalChannel> logicalChannels = new HashSet<LogicalChannel>();
        for (Image image : this.imageList.values()) {
            Pixels pixels = image.getPrimaryPixels();
            image.setObjectiveSettings(this.getUniqueObjectiveSettings(objectiveSettings, image));
            for (int c = 0; c < pixels.sizeOfChannels(); ++c) {
                Channel channel = pixels.getChannel(c);
                LogicalChannel lc = channel.getLogicalChannel();
                lc.setLightSourceSettings(this.getUniqueLightSettings(lightSettings, lc));
                lc.setDetectorSettings(this.getUniqueDetectorSettings(detectorSettings, lc));
                lc.setLightPath(this.getUniqueLightPath(lightPaths, lc.getLightPath()));
                channel.setLogicalChannel(this.getUniqueLogicalChannel(logicalChannels, lc));
            }
        }
        log.info("Unique objective settings: " + objectiveSettings.size());
        log.info("Unique light settings: " + lightSettings.size());
        log.info("Unique detector settings: " + detectorSettings.size());
        log.info("Unique light paths: " + lightPaths.size());
        log.info("Unique logical channels: " + logicalChannels.size());
    }

    private void linkFileset(FilesetJobLink link) {
        Fileset fs = link.parent().proxy();
        for (Image image : this.imageList.values()) {
            image.setFileset(fs.proxy());
        }
    }

    private ObjectiveSettings getUniqueObjectiveSettings(Set<ObjectiveSettings> uniqueSettings, Image image) {
        ObjectiveSettings s1 = image.getObjectiveSettings();
        if (s1 == null) {
            return null;
        }
        for (ObjectiveSettings s2 : uniqueSettings) {
            if (!OMEROMetadataStore.compare(s1.getCorrectionCollar(), s2.getCorrectionCollar()) || !OMEROMetadataStore.compare(s1.getMedium(), s2.getMedium()) || s1.getObjective() != s2.getObjective() || !OMEROMetadataStore.compare(s1.getRefractiveIndex(), s2.getRefractiveIndex())) continue;
            return s2;
        }
        uniqueSettings.add(s1);
        return s1;
    }

    private LightSettings getUniqueLightSettings(Set<LightSettings> uniqueSettings, LogicalChannel lc) {
        LightSettings s1 = lc.getLightSourceSettings();
        if (s1 == null) {
            return null;
        }
        for (LightSettings s2 : uniqueSettings) {
            if (!OMEROMetadataStore.compare(s1.getAttenuation(), s2.getAttenuation()) || s1.getLightSource() != s2.getLightSource() || s1.getMicrobeamManipulation() != s2.getMicrobeamManipulation() || !OMEROMetadataStore.compare(s1.getWavelength(), s2.getWavelength())) continue;
            return s2;
        }
        uniqueSettings.add(s1);
        return s1;
    }

    private DetectorSettings getUniqueDetectorSettings(Set<DetectorSettings> uniqueSettings, LogicalChannel lc) {
        DetectorSettings s1 = lc.getDetectorSettings();
        if (s1 == null) {
            return null;
        }
        for (DetectorSettings s2 : uniqueSettings) {
            if (!OMEROMetadataStore.compare(s1.getBinning(), s2.getBinning()) || s1.getDetector() != s2.getDetector() || !OMEROMetadataStore.compare(s1.getGain(), s2.getGain()) || !OMEROMetadataStore.compare(s1.getOffsetValue(), s2.getOffsetValue()) || !OMEROMetadataStore.compare(s1.getReadOutRate(), s2.getReadOutRate()) || !OMEROMetadataStore.compare(s1.getVoltage(), s2.getVoltage())) continue;
            return s2;
        }
        uniqueSettings.add(s1);
        return s1;
    }

    private LogicalChannel getUniqueLogicalChannel(Set<LogicalChannel> uniqueChannels, LogicalChannel lc) {
        if (lc == null) {
            return null;
        }
        for (LogicalChannel lc2 : uniqueChannels) {
            if (!OMEROMetadataStore.compare(lc.getMode(), lc2.getMode()) || !OMEROMetadataStore.compare(lc.getContrastMethod(), lc2.getContrastMethod()) || !OMEROMetadataStore.compare(lc.getIllumination(), lc2.getIllumination()) || !OMEROMetadataStore.compare(lc.getPhotometricInterpretation(), lc2.getPhotometricInterpretation()) || lc.getDetectorSettings() != lc2.getDetectorSettings() || !OMEROMetadataStore.compare(lc.getEmissionWave(), lc2.getEmissionWave()) || !OMEROMetadataStore.compare(lc.getExcitationWave(), lc2.getExcitationWave()) || lc.getFilterSet() != lc2.getFilterSet() || !OMEROMetadataStore.compare(lc.getFluor(), lc2.getFluor()) || lc.getLightSourceSettings() != lc2.getLightSourceSettings() || !OMEROMetadataStore.compare(lc.getName(), lc2.getName()) || !OMEROMetadataStore.compare(lc.getNdFilter(), lc2.getNdFilter()) || lc.getOtf() != lc2.getOtf() || !OMEROMetadataStore.compare(lc.getPinHoleSize(), lc2.getPinHoleSize()) || !OMEROMetadataStore.compare(lc.getPockelCellSetting(), lc2.getPockelCellSetting()) || !OMEROMetadataStore.compare(lc.getSamplesPerPixel(), lc2.getSamplesPerPixel()) || lc.getLightPath() != lc2.getLightPath()) continue;
            return lc2;
        }
        uniqueChannels.add(lc);
        return lc;
    }

    private LightPath getUniqueLightPath(Set<LightPath> uniqueLightPaths, LightPath lp) {
        if (lp == null) {
            return null;
        }
        for (LightPath lp2 : uniqueLightPaths) {
            List<Filter> exFilters2;
            List<Filter> exFilters;
            if (lp.getDichroic() != lp2.getDichroic() || !(exFilters = lp.linkedExcitationFilterList()).equals(exFilters2 = lp2.linkedExcitationFilterList())) continue;
            List<Filter> emFilters = lp.linkedEmissionFilterList();
            List<Filter> emFilters2 = lp2.linkedEmissionFilterList();
            ToStringComparator comparator = new ToStringComparator();
            Collections.sort(emFilters, comparator);
            Collections.sort(emFilters2, comparator);
            if (!emFilters.equals(emFilters2)) continue;
            return lp2;
        }
        uniqueLightPaths.add(lp);
        return lp;
    }

    public List<Pixels> saveToDB(FilesetJobLink link) {
        this.checkAndCollapseGraph();
        this.linkFileset(link);
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.saveImportGraph");
        IObject[] imageArray = this.imageList.values().toArray(new Image[this.imageList.size()]);
        IObject[] saved = this.sf.getUpdateService().saveAndReturnArray(imageArray);
        ((StopWatch)s1).stop();
        ArrayList<Pixels> toReturn = new ArrayList<Pixels>();
        for (int i = 0; i < saved.length; ++i) {
            Image image = (Image)saved[i];
            Pixels pixels = image.getPrimaryPixels();
            this.pixelsList.put(i, pixels);
            toReturn.add(pixels);
        }
        return toReturn;
    }

    private boolean isRGB(String value) {
        if (value == null) {
            return false;
        }
        value = value.toLowerCase();
        for (int i = 0; i < DOMAINS.length; ++i) {
            if (!DOMAINS[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public void populateMinMax(double[][][] imageChannelGlobalMinMax) {
        for (int i = 0; i < imageChannelGlobalMinMax.length; ++i) {
            double[][] channelGlobalMinMax = imageChannelGlobalMinMax[i];
            Pixels pixels = this.pixelsList.get(i);
            Format f = pixels.getImage().getFormat();
            String v = null;
            if (f != null) {
                v = f.getValue();
            }
            boolean rgb = this.isRGB(v);
            String type = pixels.getPixelsType().getValue();
            Pixels unloadedPixels = new Pixels(pixels.getId(), false);
            for (int c = 0; c < channelGlobalMinMax.length; ++c) {
                double[] globalMinMax = channelGlobalMinMax[c];
                Channel channel = pixels.getChannel(c);
                StatsInfo statsInfo = new StatsInfo();
                if (rgb && "uint8".equals(type)) {
                    statsInfo.setGlobalMin(0.0);
                    statsInfo.setGlobalMax(255.0);
                } else {
                    statsInfo.setGlobalMin(globalMinMax[0]);
                    statsInfo.setGlobalMax(globalMinMax[1]);
                }
                this.sql.setStatsInfo(channel, statsInfo);
            }
        }
    }

    class ToStringComparator
    implements Comparator<Filter> {
        ToStringComparator() {
        }

        @Override
        public int compare(Filter a, Filter b) {
            return a.toString().compareTo(b.toString());
        }
    }
}

