/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import net.imglib2.RandomAccess;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.composite.AbstractComposite;
import net.imglib2.view.composite.CompositeFactory;

public class NumericComposite<T extends NumericType<T>>
extends AbstractComposite<T>
implements NumericType<NumericComposite<T>> {
    protected final int length;

    public NumericComposite(RandomAccess<T> sourceAccess, int length) {
        super(sourceAccess);
        this.length = length;
    }

    @Override
    public NumericComposite<T> createVariable() {
        NumericType t = (NumericType)this.sourceAccess.get();
        NativeImg img = NativeType.class.isInstance(t) ? ((NativeType)((Object)t)).createSuitableNativeImg(new ArrayImgFactory(), new long[]{this.length}) : new ListImgFactory().create(new long[]{this.length}, t);
        return new NumericComposite(img.randomAccess(), this.length);
    }

    @Override
    public NumericComposite<T> copy() {
        return new NumericComposite(this.sourceAccess.copyRandomAccess(), this.length);
    }

    @Override
    public void set(NumericComposite<T> c) {
        this.sourceAccess.setPosition(0, this.d);
        c.sourceAccess.setPosition(0, c.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).set((Type)c.sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            c.sourceAccess.fwd(c.d);
        }
    }

    @Override
    public void add(NumericComposite<T> c) {
        this.sourceAccess.setPosition(0, this.d);
        c.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).add((NumericType)c.sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            c.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void sub(NumericComposite<T> c) {
        this.sourceAccess.setPosition(0, this.d);
        c.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).sub((NumericType)c.sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            c.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void mul(NumericComposite<T> c) {
        this.sourceAccess.setPosition(0, this.d);
        c.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).mul((NumericType)c.sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            c.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void div(NumericComposite<T> c) {
        this.sourceAccess.setPosition(0, this.d);
        c.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).div((NumericType)c.sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            c.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setZero() {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).setZero();
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setOne() {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).setOne();
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void mul(float c) {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).mul(c);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void mul(double c) {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).mul(c);
            this.sourceAccess.fwd(this.d);
        }
    }

    public static class Factory<T extends NumericType<T>>
    implements CompositeFactory<T, NumericComposite<T>> {
        protected final int numChannels;

        public Factory(int numChannels) {
            this.numChannels = numChannels;
        }

        @Override
        public NumericComposite<T> create(RandomAccess<T> sourceAccess) {
            return new NumericComposite<T>(sourceAccess, this.numChannels);
        }
    }
}

