/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.EuclideanSpace;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.Interpolant;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.outofbounds.OutOfBoundsPeriodicFactory;
import net.imglib2.outofbounds.OutOfBoundsRandomValueFactory;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.SubsampleIntervalView;
import net.imglib2.view.SubsampleView;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.CompositeView;
import net.imglib2.view.composite.GenericComposite;
import net.imglib2.view.composite.NumericComposite;
import net.imglib2.view.composite.RealComposite;

public class Views {
    public static <T, F extends EuclideanSpace> RealRandomAccessible<T> interpolate(F source, InterpolatorFactory<T, F> factory) {
        return new Interpolant<T, F>(source, factory);
    }

    public static <T> RandomAccessibleOnRealRandomAccessible<T> raster(RealRandomAccessible<T> source) {
        return new RandomAccessibleOnRealRandomAccessible<T>(source);
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extend(F randomAccessible, OutOfBoundsFactory<T, ? super F> factory) {
        return new ExtendedRandomAccessibleInterval<T, F>(randomAccessible, factory);
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendMirrorSingle(F randomAccessible) {
        return new ExtendedRandomAccessibleInterval(randomAccessible, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendMirrorDouble(F randomAccessible) {
        return new ExtendedRandomAccessibleInterval(randomAccessible, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE));
    }

    public static <T extends Type<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F randomAccessible, T value) {
        return new ExtendedRandomAccessibleInterval<T, F>(randomAccessible, new OutOfBoundsConstantValueFactory(value));
    }

    public static <T extends NumericType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendZero(F randomAccessible) {
        NumericType zero = (NumericType)((NumericType)Util.getTypeFromInterval(randomAccessible)).createVariable();
        zero.setZero();
        return new ExtendedRandomAccessibleInterval<NumericType, F>(randomAccessible, new OutOfBoundsConstantValueFactory(zero));
    }

    public static <T extends RealType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendRandom(F randomAccessible, double min, double max) {
        return new ExtendedRandomAccessibleInterval<RealType, F>(randomAccessible, new OutOfBoundsRandomValueFactory((RealType)Util.getTypeFromRandomAccess(randomAccessible), min, max));
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendPeriodic(F randomAccessible) {
        return new ExtendedRandomAccessibleInterval(randomAccessible, new OutOfBoundsPeriodicFactory());
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendBorder(F randomAccessible) {
        return new ExtendedRandomAccessibleInterval(randomAccessible, new OutOfBoundsBorderFactory());
    }

    public static <T> IntervalView<T> interval(RandomAccessible<T> randomAccessible, long[] min, long[] max) {
        return new IntervalView<T>(randomAccessible, min, max);
    }

    public static <T> IntervalView<T> interval(RandomAccessible<T> randomAccessible, Interval interval) {
        return new IntervalView<T>(randomAccessible, interval);
    }

    public static <T> MixedTransformView<T> rotate(RandomAccessible<T> randomAccessible, int fromAxis, int toAxis) {
        int n = randomAccessible.numDimensions();
        int[] component = new int[n];
        boolean[] inv = new boolean[n];
        for (int e = 0; e < n; ++e) {
            if (e == toAxis) {
                component[e] = fromAxis;
                inv[e] = true;
                continue;
            }
            component[e] = e == fromAxis ? toAxis : e;
        }
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentMapping(component);
        t.setComponentInversion(inv);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> rotate(RandomAccessibleInterval<T> interval, int fromAxis, int toAxis) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        long fromMinNew = -max[toAxis];
        long fromMaxNew = -min[toAxis];
        min[toAxis] = min[fromAxis];
        max[toAxis] = max[fromAxis];
        min[fromAxis] = fromMinNew;
        max[fromAxis] = fromMaxNew;
        return Views.interval(Views.rotate(interval, fromAxis, toAxis), min, max);
    }

    public static <T> MixedTransformView<T> permute(RandomAccessible<T> randomAccessible, int fromAxis, int toAxis) {
        int n = randomAccessible.numDimensions();
        int[] component = new int[n];
        for (int e = 0; e < n; ++e) {
            component[e] = e;
        }
        component[fromAxis] = toAxis;
        component[toAxis] = fromAxis;
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentMapping(component);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> permute(RandomAccessibleInterval<T> interval, int fromAxis, int toAxis) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        long fromMinNew = min[toAxis];
        long fromMaxNew = max[toAxis];
        min[toAxis] = min[fromAxis];
        max[toAxis] = max[fromAxis];
        min[fromAxis] = fromMinNew;
        max[fromAxis] = fromMaxNew;
        return Views.interval(Views.permute(interval, fromAxis, toAxis), min, max);
    }

    public static <T> MixedTransformView<T> translate(RandomAccessible<T> randomAccessible, long ... translation) {
        int n = randomAccessible.numDimensions();
        MixedTransform t = new MixedTransform(n, n);
        t.setInverseTranslation(translation);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> translate(RandomAccessibleInterval<T> interval, long ... translation) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] + translation[d];
            int n3 = d;
            max[n3] = max[n3] + translation[d];
        }
        return Views.interval(Views.translate(interval, translation), min, max);
    }

    public static <T> MixedTransformView<T> offset(RandomAccessible<T> randomAccessible, long ... offset) {
        int n = randomAccessible.numDimensions();
        MixedTransform t = new MixedTransform(n, n);
        t.setTranslation(offset);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> offset(RandomAccessibleInterval<T> interval, long ... offset) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] - offset[d];
            int n3 = d;
            max[n3] = max[n3] - offset[d];
        }
        return Views.interval(Views.offset(interval, offset), min, max);
    }

    public static <T> IntervalView<T> zeroMin(RandomAccessibleInterval<T> interval) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        long[] offset = new long[n];
        interval.min(offset);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            max[n2] = max[n2] - offset[d];
        }
        MixedTransform t = new MixedTransform(n, n);
        t.setTranslation(offset);
        return Views.interval(new MixedTransformView<T>(interval, t), min, max);
    }

    public static <T> MixedTransformView<T> hyperSlice(RandomAccessible<T> view, int d, long pos) {
        int m = view.numDimensions();
        int n = m - 1;
        MixedTransform t = new MixedTransform(n, m);
        long[] translation = new long[m];
        translation[d] = pos;
        boolean[] zero = new boolean[m];
        int[] component = new int[m];
        for (int e = 0; e < m; ++e) {
            if (e < d) {
                zero[e] = false;
                component[e] = e;
                continue;
            }
            if (e > d) {
                zero[e] = false;
                component[e] = e - 1;
                continue;
            }
            zero[e] = true;
            component[e] = 0;
        }
        t.setTranslation(translation);
        t.setComponentZero(zero);
        t.setComponentMapping(component);
        return new MixedTransformView<T>(view, t);
    }

    public static <T> IntervalView<T> hyperSlice(RandomAccessibleInterval<T> view, int d, long pos) {
        int m = view.numDimensions();
        int n = m - 1;
        long[] min = new long[n];
        long[] max = new long[n];
        for (int e = 0; e < m; ++e) {
            if (e < d) {
                min[e] = view.min(e);
                max[e] = view.max(e);
                continue;
            }
            if (e <= d) continue;
            min[e - 1] = view.min(e);
            max[e - 1] = view.max(e);
        }
        return Views.interval(Views.hyperSlice(view, d, pos), min, max);
    }

    public static <T> MixedTransformView<T> addDimension(RandomAccessible<T> randomAccessible) {
        int m = randomAccessible.numDimensions();
        int n = m + 1;
        MixedTransform t = new MixedTransform(n, m);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> addDimension(RandomAccessibleInterval<T> interval, long minOfNewDim, long maxOfNewDim) {
        int m = interval.numDimensions();
        long[] min = new long[m + 1];
        long[] max = new long[m + 1];
        for (int d = 0; d < m; ++d) {
            min[d] = interval.min(d);
            max[d] = interval.max(d);
        }
        min[m] = minOfNewDim;
        max[m] = maxOfNewDim;
        return Views.interval(Views.addDimension(interval), min, max);
    }

    public static <T> MixedTransformView<T> invertAxis(RandomAccessible<T> randomAccessible, int d) {
        int n = randomAccessible.numDimensions();
        boolean[] inv = new boolean[n];
        inv[d] = true;
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentInversion(inv);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> invertAxis(RandomAccessibleInterval<T> interval, int d) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        long tmp = min[d];
        min[d] = -max[d];
        max[d] = -tmp;
        return Views.interval(Views.invertAxis(interval, d), min, max);
    }

    public static <T> IntervalView<T> offsetInterval(RandomAccessible<T> randomAccessible, long[] offset, long[] dimension) {
        int n = randomAccessible.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            max[d] = dimension[d] - 1L;
        }
        return Views.interval(Views.offset(randomAccessible, offset), min, max);
    }

    public static <T> IntervalView<T> offsetInterval(RandomAccessible<T> randomAccessible, Interval interval) {
        int n = randomAccessible.numDimensions();
        long[] offset = new long[n];
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(offset);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            max[n2] = max[n2] - offset[d];
        }
        return Views.interval(Views.offset(randomAccessible, offset), min, max);
    }

    public static boolean isZeroMin(Interval interval) {
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.min(d) == 0L) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static <T> IntervalView<T> flippedView(RandomAccessibleInterval<T> interval, int d) {
        return Views.zeroMin(Views.invertAxis(interval, d));
    }

    @Deprecated
    public static <T> IntervalView<T> rotatedView(RandomAccessibleInterval<T> interval, int fromAxis, int toAxis) {
        return Views.zeroMin(Views.rotate(interval, fromAxis, toAxis));
    }

    @Deprecated
    public static <T> IntervalView<T> superIntervalView(RandomAccessible<T> randomAccessible, long[] offset, long[] dimension) {
        return Views.offsetInterval(randomAccessible, offset, dimension);
    }

    public static <T> IterableInterval<T> iterable(RandomAccessibleInterval<T> randomAccessibleInterval) {
        if (IterableInterval.class.isInstance(randomAccessibleInterval)) {
            return (IterableInterval)((Object)randomAccessibleInterval);
        }
        return new IterableRandomAccessibleInterval<T>(randomAccessibleInterval);
    }

    public static <T> IterableInterval<T> flatIterable(RandomAccessibleInterval<T> randomAccessibleInterval) {
        if (IterableInterval.class.isInstance(randomAccessibleInterval) && FlatIterationOrder.class.isInstance(((IterableInterval)((Object)randomAccessibleInterval)).iterationOrder())) {
            return (IterableInterval)((Object)randomAccessibleInterval);
        }
        return new IterableRandomAccessibleInterval<T>(randomAccessibleInterval);
    }

    public static <T> CompositeIntervalView<T, ? extends GenericComposite<T>> collapse(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new GenericComposite.Factory());
    }

    public static <T extends RealType<T>> CompositeIntervalView<T, RealComposite<T>> collapseReal(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new RealComposite.Factory((int)source.dimension(source.numDimensions() - 1)));
    }

    public static <T extends NumericType<T>> CompositeIntervalView<T, NumericComposite<T>> collapseNumeric(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new NumericComposite.Factory((int)source.dimension(source.numDimensions() - 1)));
    }

    public static <T> CompositeView<T, ? extends GenericComposite<T>> collapse(RandomAccessible<T> source) {
        return new CompositeView(source, new GenericComposite.Factory());
    }

    public static <T extends RealType<T>> CompositeView<T, RealComposite<T>> collapseReal(RandomAccessible<T> source, int numChannels) {
        return new CompositeView(source, new RealComposite.Factory(numChannels));
    }

    public static <T extends NumericType<T>> CompositeView<T, NumericComposite<T>> collapseNumeric(RandomAccessible<T> source, int numChannels) {
        return new CompositeView(source, new NumericComposite.Factory(numChannels));
    }

    public static <T> SubsampleIntervalView<T> subsample(RandomAccessibleInterval<T> source, long step) {
        return new SubsampleIntervalView<T>(source, step);
    }

    public static <T> SubsampleView<T> subsample(RandomAccessibleInterval<T> source, long ... steps) {
        assert (steps.length >= source.numDimensions()) : "Dimensions do not match.";
        return new SubsampleIntervalView<T>(source, steps);
    }

    public static <T> SubsampleView<T> subsample(RandomAccessible<T> source, long step) {
        return new SubsampleView<T>(source, step);
    }

    public static <T> SubsampleView<T> subsample(RandomAccessible<T> source, long ... steps) {
        assert (steps.length >= source.numDimensions()) : "Dimensions do not match.";
        return new SubsampleView<T>(source, steps);
    }
}

