/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.LinkedList;
import java.util.ListIterator;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.concatenate.Util;
import net.imglib2.img.WrappedImg;
import net.imglib2.transform.Transform;
import net.imglib2.transform.integer.AbstractMixedTransform;
import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.BoundingBoxTransform;
import net.imglib2.transform.integer.Mixed;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.transform.integer.SlicingTransform;
import net.imglib2.transform.integer.TranslationTransform;
import net.imglib2.util.Intervals;
import net.imglib2.view.FullSourceMapMixedRandomAccess;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedRandomAccess;
import net.imglib2.view.SlicingRandomAccess;
import net.imglib2.view.TransformRandomAccess;
import net.imglib2.view.TransformedRandomAccessible;
import net.imglib2.view.TranslationRandomAccess;

public class TransformBuilder<T> {
    protected RandomAccessible<T> source;
    protected BoundingBox boundingBox;
    protected LinkedList<Transform> transforms = new LinkedList();

    public static <S> RandomAccessible<S> getEfficientRandomAccessible(Interval interval, RandomAccessible<S> randomAccessible) {
        return new TransformBuilder<S>(interval, randomAccessible).build();
    }

    protected TransformBuilder(Interval interval, RandomAccessible<T> randomAccessible) {
        this.boundingBox = interval == null ? null : new BoundingBox(interval);
        this.visit(randomAccessible);
        this.simplifyTransforms();
    }

    protected void prependTransform(Transform t) {
        this.boundingBox = BoundingBoxTransform.class.isInstance(t) && this.boundingBox != null ? ((BoundingBoxTransform)((Object)t)).transform(this.boundingBox) : null;
        this.transforms.addFirst(t);
    }

    protected void visit(RandomAccessible<T> randomAccessible) {
        if (TransformedRandomAccessible.class.isInstance(randomAccessible)) {
            this.visitTransformed((TransformedRandomAccessible)randomAccessible);
        } else if (ExtendedRandomAccessibleInterval.class.isInstance(randomAccessible)) {
            this.visitExtended((ExtendedRandomAccessibleInterval)randomAccessible);
        } else if (IntervalView.class.isInstance(randomAccessible)) {
            this.visit(((IntervalView)randomAccessible).getSource());
        } else if (WrappedImg.class.isInstance(randomAccessible)) {
            this.visit(((WrappedImg)((Object)randomAccessible)).getImg());
        } else {
            this.source = randomAccessible;
        }
    }

    protected void visitTransformed(TransformedRandomAccessible<T> randomAccessible) {
        this.prependTransform(randomAccessible.getTransformToSource());
        this.visit(randomAccessible.getSource());
    }

    protected void visitExtended(ExtendedRandomAccessibleInterval<T, ?> randomAccessible) {
        Object sourceInterval = randomAccessible.getSource();
        if (this.boundingBox != null && Intervals.contains(sourceInterval, this.boundingBox.getInterval())) {
            this.visit((RandomAccessible<T>)sourceInterval);
        } else {
            this.source = randomAccessible;
        }
    }

    public static boolean isIdentity(Mixed t) {
        int m;
        int n = t.numSourceDimensions();
        if (n != (m = t.numTargetDimensions())) {
            return false;
        }
        for (int d = 0; d < m; ++d) {
            if (t.getTranslation(d) != 0L) {
                return false;
            }
            if (t.getComponentZero(d)) {
                return false;
            }
            if (t.getComponentInversion(d)) {
                return false;
            }
            if (t.getComponentMapping(d) == d) continue;
            return false;
        }
        return true;
    }

    public static boolean isTranslation(Mixed t) {
        int m;
        int n = t.numSourceDimensions();
        if (n != (m = t.numTargetDimensions())) {
            return false;
        }
        for (int d = 0; d < m; ++d) {
            if (t.getComponentZero(d)) {
                return false;
            }
            if (t.getComponentInversion(d)) {
                return false;
            }
            if (t.getComponentMapping(d) == d) continue;
            return false;
        }
        return true;
    }

    public static boolean isComponentMapping(Mixed t) {
        int m = t.numTargetDimensions();
        for (int d = 0; d < m; ++d) {
            if (t.getTranslation(d) != 0L) {
                return false;
            }
            if (t.getComponentZero(d)) {
                return false;
            }
            if (!t.getComponentInversion(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSlicing(Mixed t) {
        int m;
        int n = t.numSourceDimensions();
        if (n > (m = t.numTargetDimensions())) {
            return false;
        }
        for (int d = 0; d < m; ++d) {
            if (t.getTranslation(d) != 0L && !t.getComponentZero(d)) {
                return false;
            }
            if (!t.getComponentInversion(d)) continue;
            return false;
        }
        return true;
    }

    protected void simplifyTransforms() {
        Util.join(this.transforms);
        ListIterator<AbstractMixedTransform> i = this.transforms.listIterator();
        while (i.hasNext()) {
            Transform t = (Transform)i.next();
            if (!Mixed.class.isInstance(t)) continue;
            Mixed mixed = (Mixed)t;
            if (TransformBuilder.isIdentity(mixed)) {
                i.remove();
                continue;
            }
            if (TransformBuilder.isTranslation(mixed)) {
                long[] translation = new long[mixed.numTargetDimensions()];
                mixed.getTranslation(translation);
                i.set(new TranslationTransform(translation));
                continue;
            }
            if (!TransformBuilder.isSlicing(mixed)) continue;
            int m = mixed.numTargetDimensions();
            long[] translation = new long[m];
            boolean[] zero = new boolean[m];
            int[] component = new int[m];
            mixed.getTranslation(translation);
            mixed.getComponentZero(zero);
            mixed.getComponentMapping(component);
            SlicingTransform sl = new SlicingTransform(mixed.numSourceDimensions(), m);
            sl.setTranslation(translation);
            sl.setComponentZero(zero);
            sl.setComponentMapping(component);
            i.set(sl);
        }
    }

    protected RandomAccessible<T> build() {
        RandomAccessible<T> result = this.source;
        ListIterator i = this.transforms.listIterator();
        while (i.hasNext()) {
            Transform t = (Transform)i.next();
            if (MixedTransform.class.isInstance(t)) {
                result = this.wrapMixedTransform(result, (MixedTransform)t);
                continue;
            }
            if (TranslationTransform.class.isInstance(t)) {
                result = this.wrapTranslationTransform(result, (TranslationTransform)t);
                continue;
            }
            if (SlicingTransform.class.isInstance(t)) {
                result = this.wrapSlicingTransform(result, (SlicingTransform)t);
                continue;
            }
            result = this.wrapGenericTransform(result, t);
        }
        return result;
    }

    protected RandomAccessible<T> wrapGenericTransform(final RandomAccessible<T> s, final Transform t) {
        return new RandomAccessible<T>(){

            @Override
            public int numDimensions() {
                return t.numSourceDimensions();
            }

            @Override
            public RandomAccess<T> randomAccess() {
                return new TransformRandomAccess(s.randomAccess(), t);
            }

            @Override
            public RandomAccess<T> randomAccess(Interval interval) {
                return new TransformRandomAccess(s.randomAccess(), t);
            }
        };
    }

    protected RandomAccessible<T> wrapMixedTransform(final RandomAccessible<T> s, final MixedTransform t) {
        final boolean full = t.hasFullSourceMapping();
        return new RandomAccessible<T>(){

            @Override
            public int numDimensions() {
                return t.numSourceDimensions();
            }

            @Override
            public RandomAccess<T> randomAccess() {
                if (full) {
                    return new FullSourceMapMixedRandomAccess(s.randomAccess(), t);
                }
                return new MixedRandomAccess(s.randomAccess(), t);
            }

            @Override
            public RandomAccess<T> randomAccess(Interval interval) {
                if (full) {
                    return new FullSourceMapMixedRandomAccess(s.randomAccess(), t);
                }
                return new MixedRandomAccess(s.randomAccess(), t);
            }
        };
    }

    protected RandomAccessible<T> wrapTranslationTransform(final RandomAccessible<T> s, final TranslationTransform t) {
        return new RandomAccessible<T>(){

            @Override
            public int numDimensions() {
                return t.numSourceDimensions();
            }

            @Override
            public TranslationRandomAccess<T> randomAccess() {
                return new TranslationRandomAccess(s.randomAccess(), t);
            }

            @Override
            public TranslationRandomAccess<T> randomAccess(Interval interval) {
                return new TranslationRandomAccess(s.randomAccess(), t);
            }
        };
    }

    protected RandomAccessible<T> wrapSlicingTransform(final RandomAccessible<T> s, final SlicingTransform t) {
        return new RandomAccessible<T>(){

            @Override
            public int numDimensions() {
                return t.numSourceDimensions();
            }

            @Override
            public SlicingRandomAccess<T> randomAccess() {
                return new SlicingRandomAccess(s.randomAccess(), t);
            }

            @Override
            public SlicingRandomAccess<T> randomAccess(Interval interval) {
                return new SlicingRandomAccess(s.randomAccess(), t);
            }
        };
    }
}

