/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.Positionable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.view.SubsampleView;
import net.imglib2.view.Views;

public class SubsampleIntervalView<T>
extends SubsampleView<T>
implements RandomAccessibleInterval<T> {
    protected final long[] dimensions;
    protected final long[] max;

    public SubsampleIntervalView(RandomAccessibleInterval<T> source, long step) {
        super(Views.zeroMin(source), step);
        this.dimensions = new long[this.steps.length];
        this.max = new long[this.steps.length];
        for (int d = 0; d < this.steps.length; ++d) {
            this.steps[d] = step;
            this.dimensions[d] = source.dimension(d) / step;
            this.max[d] = this.dimensions[d] - 1L;
        }
    }

    public SubsampleIntervalView(RandomAccessibleInterval<T> source, long ... steps) {
        super(Views.zeroMin(source), steps);
        this.dimensions = new long[steps.length];
        this.max = new long[steps.length];
        for (int d = 0; d < steps.length; ++d) {
            this.steps[d] = steps[d];
            this.dimensions[d] = source.dimension(d) / steps[d];
            this.max[d] = this.dimensions[d] - 1L;
        }
    }

    @Override
    public long min(int d) {
        return 0L;
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.steps.length; ++d) {
            min[d] = 0L;
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.steps.length; ++d) {
            min.setPosition(0, d);
        }
    }

    @Override
    public long max(int d) {
        return this.max[d];
    }

    @Override
    public void max(long[] m) {
        for (int d = 0; d < this.steps.length; ++d) {
            m[d] = this.max[d];
        }
    }

    @Override
    public void max(Positionable m) {
        for (int d = 0; d < this.steps.length; ++d) {
            m.setPosition(this.max[d], d);
        }
    }

    @Override
    public double realMin(int d) {
        return 0.0;
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.steps.length; ++d) {
            min[d] = 0.0;
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.steps.length; ++d) {
            min.setPosition(0, d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.max[d];
    }

    @Override
    public void realMax(double[] m) {
        for (int d = 0; d < this.steps.length; ++d) {
            m[d] = this.max[d];
        }
    }

    @Override
    public void realMax(RealPositionable m) {
        for (int d = 0; d < this.steps.length; ++d) {
            m.setPosition(this.max[d], d);
        }
    }

    @Override
    public void dimensions(long[] dim) {
        for (int d = 0; d < this.steps.length; ++d) {
            dim[d] = this.dimensions[d];
        }
    }

    @Override
    public long dimension(int d) {
        return this.dimensions[d];
    }
}

