/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.util.Iterator;
import java.util.List;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ExponentialMathType;
import net.imglib2.util.Intervals;

public class Util {
    public static <T> T[] genericArray(int length) {
        return new Object[length];
    }

    public static double log2(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    public static double[] getArrayFromValue(double value, int numDimensions) {
        double[] values = new double[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            values[d] = value;
        }
        return values;
    }

    public static float[] getArrayFromValue(float value, int numDimensions) {
        float[] values = new float[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            values[d] = value;
        }
        return values;
    }

    public static int[] getArrayFromValue(int value, int numDimensions) {
        int[] values = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            values[d] = value;
        }
        return values;
    }

    public static long[] getArrayFromValue(long value, int numDimensions) {
        long[] values = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            values[d] = value;
        }
        return values;
    }

    public static final float computeDistance(RealLocalizable position1, RealLocalizable position2) {
        float dist = 0.0f;
        int n = position1.numDimensions();
        for (int d = 0; d < n; ++d) {
            float pos = position2.getFloatPosition(d) - position1.getFloatPosition(d);
            dist += pos * pos;
        }
        return (float)Math.sqrt(dist);
    }

    public static final float computeDistance(int[] position1, int[] position2) {
        float dist = 0.0f;
        for (int d = 0; d < position1.length; ++d) {
            int pos = position2[d] - position1[d];
            dist += (float)(pos * pos);
        }
        return (float)Math.sqrt(dist);
    }

    public static final float computeDistance(long[] position1, long[] position2) {
        float dist = 0.0f;
        for (int d = 0; d < position1.length; ++d) {
            long pos = position2[d] - position1[d];
            dist += (float)(pos * pos);
        }
        return (float)Math.sqrt(dist);
    }

    public static final float computeLength(int[] position) {
        float dist = 0.0f;
        for (int d = 0; d < position.length; ++d) {
            int pos = position[d];
            dist += (float)(pos * pos);
        }
        return (float)Math.sqrt(dist);
    }

    public static final float computeLength(long[] position) {
        float dist = 0.0f;
        for (int d = 0; d < position.length; ++d) {
            long pos = position[d];
            dist += (float)(pos * pos);
        }
        return (float)Math.sqrt(dist);
    }

    public static long computeMedian(long[] values) {
        long[] temp = (long[])values.clone();
        int length = temp.length;
        Util.quicksort(temp, 0, length - 1);
        long median = length % 2 == 1 ? temp[length / 2] : (temp[length / 2] + temp[length / 2 - 1]) / 2L;
        return median;
    }

    public static double computeMedian(double[] values) {
        double[] temp = (double[])values.clone();
        int length = temp.length;
        Util.quicksort(temp, 0, length - 1);
        double median = length % 2 == 1 ? temp[length / 2] : (temp[length / 2] + temp[length / 2 - 1]) / 2.0;
        return median;
    }

    public static double computePercentile(double[] values, double percentile) {
        double[] temp = (double[])values.clone();
        int length = temp.length;
        Util.quicksort(temp);
        return temp[Math.min(length - 1, Math.max(0, (int)Math.round((double)(length - 1) * percentile)))];
    }

    public static double computeAverageDouble(List<Double> values) {
        double size = values.size();
        double avg = 0.0;
        for (double v : values) {
            avg += v / size;
        }
        return avg;
    }

    public static float computeAverageFloat(List<Float> values) {
        double size = values.size();
        double avg = 0.0;
        Iterator<Float> i$ = values.iterator();
        while (i$.hasNext()) {
            double v = i$.next().floatValue();
            avg += v / size;
        }
        return (float)avg;
    }

    public static float computeMinimum(List<Float> values) {
        float min = Float.MAX_VALUE;
        for (float v : values) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static float computeMaximum(List<Float> values) {
        float max = -3.4028235E38f;
        for (float v : values) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static float computeAverage(float[] values) {
        double size = values.length;
        double avg = 0.0;
        for (float v : values) {
            avg += (double)v / size;
        }
        return (float)avg;
    }

    public static double computeAverage(double[] values) {
        double size = values.length;
        double avg = 0.0;
        for (double v : values) {
            avg += v / size;
        }
        return avg;
    }

    public static double computeMin(double[] values) {
        double min = values[0];
        for (double v : values) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static double computeMax(double[] values) {
        double max = values[0];
        for (double v : values) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static float computeMedian(float[] values) {
        float[] temp = (float[])values.clone();
        int length = temp.length;
        Util.quicksort(temp, 0, length - 1);
        float median = length % 2 == 1 ? temp[length / 2] : (temp[length / 2] + temp[length / 2 - 1]) / 2.0f;
        return median;
    }

    public static void quicksort(long[] data, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        long x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                long temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            Util.quicksort(data, left, j);
        }
        if (i < right) {
            Util.quicksort(data, i, right);
        }
    }

    public static void quicksort(double[] data) {
        Util.quicksort(data, 0, data.length - 1);
    }

    public static void quicksort(double[] data, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        double x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                double temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            Util.quicksort(data, left, j);
        }
        if (i < right) {
            Util.quicksort(data, i, right);
        }
    }

    public static void quicksort(float[] data) {
        Util.quicksort(data, 0, data.length - 1);
    }

    public static void quicksort(float[] data, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        float x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                float temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            Util.quicksort(data, left, j);
        }
        if (i < right) {
            Util.quicksort(data, i, right);
        }
    }

    public static void quicksort(double[] data, int[] sortAlso, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        double x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                double temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                int temp2 = sortAlso[i];
                sortAlso[i] = sortAlso[j];
                sortAlso[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            Util.quicksort(data, sortAlso, left, j);
        }
        if (i < right) {
            Util.quicksort(data, sortAlso, i, right);
        }
    }

    public static double gLog(double z, double c) {
        if (c == 0.0) {
            return z;
        }
        return Math.log10((z + Math.sqrt(z * z + c * c)) / 2.0);
    }

    public static float gLog(float z, float c) {
        if (c == 0.0f) {
            return z;
        }
        return (float)Math.log10(((double)z + Math.sqrt(z * z + c * c)) / 2.0);
    }

    public static double gLogInv(double w, double c) {
        if (c == 0.0) {
            return w;
        }
        return Math.pow(10.0, w) - c * c * Math.pow(10.0, -w) / 4.0;
    }

    public static double gLogInv(float w, float c) {
        if (c == 0.0f) {
            return w;
        }
        return Math.pow(10.0, w) - (double)(c * c) * Math.pow(10.0, -w) / 4.0;
    }

    public static boolean isApproxEqual(float a, float b, float threshold) {
        if (a == b) {
            return true;
        }
        return a + threshold > b && a - threshold < b;
    }

    public static boolean isApproxEqual(double a, double b, double threshold) {
        if (a == b) {
            return true;
        }
        return a + threshold > b && a - threshold < b;
    }

    public static int round(float value) {
        return (int)(value + 0.5f * Math.signum(value));
    }

    public static long round(double value) {
        return (long)(value + 0.5 * Math.signum(value));
    }

    public static double[] createGaussianKernel1DDouble(double sigma, boolean normalize) {
        double[] gaussianKernel;
        int size = 3;
        if (sigma <= 0.0) {
            gaussianKernel = new double[3];
            gaussianKernel[1] = 1.0;
        } else {
            size = Math.max(3, 2 * (int)(3.0 * sigma + 0.5) + 1);
            double two_sq_sigma = 2.0 * sigma * sigma;
            gaussianKernel = new double[size];
            for (int x = size / 2; x >= 0; --x) {
                double val;
                gaussianKernel[size / 2 - x] = val = Math.exp((double)(-(x * x)) / two_sq_sigma);
                gaussianKernel[size / 2 + x] = val;
            }
        }
        if (normalize) {
            double sum = 0.0;
            for (double value : gaussianKernel) {
                sum += value;
            }
            int i = 0;
            while (i < gaussianKernel.length) {
                int n = i++;
                gaussianKernel[n] = gaussianKernel[n] / sum;
            }
        }
        return gaussianKernel;
    }

    public static <T extends ExponentialMathType<T>> T[] createGaussianKernel1D(T sigma, boolean normalize) {
        int i;
        ExponentialMathType[] gaussianKernel;
        int kernelSize;
        ExponentialMathType zero = (ExponentialMathType)sigma.createVariable();
        ExponentialMathType two = (ExponentialMathType)sigma.createVariable();
        ExponentialMathType one = (ExponentialMathType)sigma.createVariable();
        ExponentialMathType minusOne = (ExponentialMathType)sigma.createVariable();
        ExponentialMathType two_sq_sigma = (ExponentialMathType)zero.createVariable();
        ExponentialMathType sum = (ExponentialMathType)sigma.createVariable();
        ExponentialMathType value = (ExponentialMathType)sigma.createVariable();
        ExponentialMathType xPos = (ExponentialMathType)sigma.createVariable();
        ExponentialMathType cs = (ExponentialMathType)sigma.createVariable();
        zero.setZero();
        one.setOne();
        two.setOne();
        two.add(one);
        minusOne.setZero();
        minusOne.sub(one);
        if (sigma.compareTo((ExponentialMathType)zero) <= 0) {
            kernelSize = 3;
            gaussianKernel = (ExponentialMathType[])Util.genericArray(3);
            gaussianKernel[1].set(one);
        } else {
            int x;
            cs.set(sigma);
            cs.mul(3.0);
            cs.round();
            cs.mul(2.0);
            cs.add(one);
            kernelSize = Util.round(cs.getRealFloat());
            kernelSize = Math.max(3, kernelSize);
            if (kernelSize % 2 == 0) {
                ++kernelSize;
            }
            two_sq_sigma.set(two);
            two_sq_sigma.mul(sigma);
            two_sq_sigma.mul(sigma);
            gaussianKernel = (ExponentialMathType[])Util.genericArray(kernelSize);
            for (i = 0; i < gaussianKernel.length; ++i) {
                gaussianKernel[i] = (ExponentialMathType)zero.createVariable();
            }
            xPos.setZero();
            for (x = 1; x <= kernelSize / 2; ++x) {
                xPos.add(one);
            }
            for (x = kernelSize / 2; x >= 0; --x) {
                value.set(xPos);
                value.mul(xPos);
                value.mul(minusOne);
                value.div(two_sq_sigma);
                value.exp();
                gaussianKernel[kernelSize / 2 - x].set(value);
                gaussianKernel[kernelSize / 2 + x].set(value);
                xPos.sub(one);
            }
        }
        if (normalize) {
            sum.setZero();
            for (ExponentialMathType val : gaussianKernel) {
                sum.add(val);
            }
            for (i = 0; i < gaussianKernel.length; ++i) {
                gaussianKernel[i].div(sum);
            }
        }
        for (i = 0; i < gaussianKernel.length; ++i) {
            System.out.println(gaussianKernel[i]);
        }
        return gaussianKernel;
    }

    public static int getSuggestedKernelDiameter(double sigma) {
        int size = 3;
        if (sigma > 0.0) {
            size = Math.max(3, 2 * (int)(3.0 * sigma + 0.5) + 1);
        }
        return size;
    }

    public static String printCoordinates(float[] value) {
        String out = "(Array empty)";
        if (value == null || value.length == 0) {
            return out;
        }
        out = "(" + value[0];
        for (int i = 1; i < value.length; ++i) {
            out = out + ", " + value[i];
        }
        out = out + ")";
        return out;
    }

    public static String printCoordinates(double[] value) {
        String out = "(Array empty)";
        if (value == null || value.length == 0) {
            return out;
        }
        out = "(" + value[0];
        for (int i = 1; i < value.length; ++i) {
            out = out + ", " + value[i];
        }
        out = out + ")";
        return out;
    }

    public static String printCoordinates(RealLocalizable localizable) {
        String out = "(RealLocalizable empty)";
        if (localizable == null || localizable.numDimensions() == 0) {
            return out;
        }
        out = "(" + localizable.getFloatPosition(0);
        for (int i = 1; i < localizable.numDimensions(); ++i) {
            out = out + ", " + localizable.getFloatPosition(i);
        }
        out = out + ")";
        return out;
    }

    public static String printInterval(Interval interval) {
        int i;
        String out = "(Interval empty)";
        if (interval == null || interval.numDimensions() == 0) {
            return out;
        }
        out = "[" + interval.min(0);
        for (i = 1; i < interval.numDimensions(); ++i) {
            out = out + ", " + interval.min(i);
        }
        out = out + "] -> [" + interval.max(0);
        for (i = 1; i < interval.numDimensions(); ++i) {
            out = out + ", " + interval.max(i);
        }
        out = out + "], dimensions (" + interval.dimension(0);
        for (i = 1; i < interval.numDimensions(); ++i) {
            out = out + ", " + interval.dimension(i);
        }
        out = out + ")";
        return out;
    }

    public static String printCoordinates(int[] value) {
        String out = "(Array empty)";
        if (value == null || value.length == 0) {
            return out;
        }
        out = "(" + value[0];
        for (int i = 1; i < value.length; ++i) {
            out = out + ", " + value[i];
        }
        out = out + ")";
        return out;
    }

    public static String printCoordinates(long[] value) {
        String out = "(Array empty)";
        if (value == null || value.length == 0) {
            return out;
        }
        out = "(" + value[0];
        for (int i = 1; i < value.length; ++i) {
            out = out + ", " + value[i];
        }
        out = out + ")";
        return out;
    }

    public static String printCoordinates(boolean[] value) {
        String out = "(Array empty)";
        if (value == null || value.length == 0) {
            return out;
        }
        out = "(";
        out = value[0] ? out + "1" : out + "0";
        for (int i = 1; i < value.length; ++i) {
            out = out + ", ";
            out = value[i] ? out + "1" : out + "0";
        }
        out = out + ")";
        return out;
    }

    public static int pow(int a, int b) {
        if (b == 0) {
            return 1;
        }
        if (b == 1) {
            return a;
        }
        int result = a;
        for (int i = 1; i < b; ++i) {
            result *= a;
        }
        return result;
    }

    public static <T extends Type<T> & Comparable<T>> T max(T value1, T value2) {
        if (((Comparable<T>)value1).compareTo(value2) >= 0) {
            return value1;
        }
        return value2;
    }

    public static <T extends Type<T> & Comparable<T>> T min(T value1, T value2) {
        if (((Comparable<T>)value1).compareTo(value2) <= 0) {
            return value1;
        }
        return value2;
    }

    public static boolean[][] getRecursiveCoordinates(int numDimensions) {
        boolean[][] positions = new boolean[Util.pow(2, numDimensions)][numDimensions];
        Util.setCoordinateRecursive(numDimensions - 1, numDimensions, new int[numDimensions], positions);
        return positions;
    }

    public static void setCoordinateRecursive(int dimension, int numDimensions, int[] location, boolean[][] result) {
        int[] newLocation0 = new int[numDimensions];
        int[] newLocation1 = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            newLocation0[d] = location[d];
            newLocation1[d] = location[d];
        }
        newLocation0[dimension] = 0;
        newLocation1[dimension] = 1;
        if (dimension == 0) {
            int d;
            int index0 = 0;
            int index1 = 0;
            for (d = 0; d < numDimensions; ++d) {
                index0 += newLocation0[d] * Util.pow(2, d);
                index1 += newLocation1[d] * Util.pow(2, d);
            }
            for (d = 0; d < numDimensions; ++d) {
                result[index0][d] = newLocation0[d] == 1;
                result[index1][d] = newLocation1[d] == 1;
            }
        } else {
            Util.setCoordinateRecursive(dimension - 1, numDimensions, newLocation0, result);
            Util.setCoordinateRecursive(dimension - 1, numDimensions, newLocation1, result);
        }
    }

    public static final long[] intervalDimensions(Interval interval) {
        long[] dimensions = new long[interval.numDimensions()];
        interval.dimensions(dimensions);
        return dimensions;
    }

    public static final int[] long2int(long[] a) {
        int[] i = new int[a.length];
        for (int d = 0; d < a.length; ++d) {
            i[d] = (int)a[d];
        }
        return i;
    }

    public static final long[] int2long(int[] i) {
        long[] l = new long[i.length];
        for (int d = 0; d < l.length; ++d) {
            l[d] = i[d];
        }
        return l;
    }

    public static final long[] intervalMax(Interval interval) {
        long[] max = new long[interval.numDimensions()];
        interval.max(max);
        return max;
    }

    public static final long[] intervalMin(Interval interval) {
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        return min;
    }

    public static final double[] realIntervalDimensions(RealInterval interval) {
        int n = interval.numDimensions();
        double[] dimensions = new double[interval.numDimensions()];
        for (int d = 0; d < n; ++d) {
            dimensions[d] = interval.realMax(d) - interval.realMin(d);
        }
        return dimensions;
    }

    public static final double[] realIntervalMax(RealInterval interval) {
        int n = interval.numDimensions();
        double[] max = new double[interval.numDimensions()];
        for (int d = 0; d < n; ++d) {
            max[d] = interval.realMax(d);
        }
        return max;
    }

    public static final double[] realIntervalMin(RealInterval interval) {
        int n = interval.numDimensions();
        double[] min = new double[interval.numDimensions()];
        for (int d = 0; d < n; ++d) {
            min[d] = interval.realMin(d);
        }
        return min;
    }

    public static final <T, F extends Interval & RandomAccessible<T>> T getTypeFromInterval(F rai) {
        RandomAccess<T> randomAccess = ((RandomAccessible<T>)rai).randomAccess();
        rai.min(randomAccess);
        return randomAccess.get();
    }

    public static final <T> T getTypeFromRandomAccess(RandomAccessible<T> ra) {
        if (RandomAccessibleInterval.class.isInstance(ra)) {
            return Util.getTypeFromInterval((RandomAccessibleInterval)ra);
        }
        return ra.randomAccess().get();
    }

    public static final <T, F extends RealInterval & RealRandomAccessible<T>> T getTypeFromRealInterval(F rai) {
        RealRandomAccess<T> realRandomAccess = ((RealRandomAccessible<T>)rai).realRandomAccess();
        rai.realMin(realRandomAccess);
        return realRandomAccess.get();
    }

    public static final <T> T getTypeFromRealRandomAccess(RealRandomAccessible<T> ra) {
        if (RealRandomAccessibleRealInterval.class.isInstance(ra)) {
            return Util.getTypeFromRealInterval((RealRandomAccessibleRealInterval)ra);
        }
        return ra.realRandomAccess().get();
    }

    public static <T extends NativeType<T>> ImgFactory<T> getArrayOrCellImgFactory(Dimensions targetSize, T type) {
        if (Intervals.numElements(targetSize) <= Integer.MAX_VALUE) {
            return new ArrayImgFactory();
        }
        int cellSize = (int)Math.pow(Integer.MAX_VALUE / type.getEntitiesPerPixel(), 1.0 / (double)targetSize.numDimensions());
        return new CellImgFactory(cellSize);
    }

    public static <T extends NativeType<T>> ImgFactory<T> getArrayOrCellImgFactory(Dimensions targetSize, int targetCellSize, T type) {
        if (Intervals.numElements(targetSize) <= Integer.MAX_VALUE) {
            return new ArrayImgFactory();
        }
        int cellSize = Math.pow(targetCellSize, targetSize.numDimensions()) <= 2.147483647E9 ? targetCellSize : (int)Math.pow(Integer.MAX_VALUE / type.getEntitiesPerPixel(), 1.0 / (double)targetSize.numDimensions());
        return new CellImgFactory(cellSize);
    }

    public static final int ldu(int v) {
        int c = 0;
        do {
            ++c;
        } while ((v >>= 1) > 1);
        return c;
    }

    public static boolean equalIterationOrder(IterableInterval<?> ... intervals) {
        Object order = intervals[0].iterationOrder();
        for (int i = 1; i < intervals.length; ++i) {
            if (order.equals(intervals[i].iterationOrder())) continue;
            return false;
        }
        return true;
    }

    public static final void min(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(b[i] < a[i])) continue;
            a[i] = b[i];
        }
    }

    public static final void max(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(b[i] > a[i])) continue;
            a[i] = b[i];
        }
    }
}

