/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.outofbounds.OutOfBoundsPeriodicFactory;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class ImgTestHelper {
    private static final long[][] DIM = new long[][]{{127L}, {288L}, {135L, 111L}, {172L, 131L}, {15L, 13L, 33L}, {110L, 38L, 30L}, {109L, 34L, 111L}, {12L, 43L, 92L, 10L}, {21L, 34L, 29L, 13L}, {5L, 12L, 30L, 4L, 21L}, {14L, 21L, 13L, 9L, 12L}};

    public static long[][] dims() {
        return (long[][])DIM.clone();
    }

    public static boolean testImg(long[] size, ImgFactory<FloatType> factory1, ImgFactory<FloatType> factory2) {
        Img<FloatType> img1 = factory1.create(size, new FloatType());
        Img<FloatType> img2 = factory2.create(size, new FloatType());
        int numDimensions = img1.numDimensions();
        float[] reference = ImgTestHelper.createReference(img1);
        Cursor cursor1 = img1.cursor();
        Cursor cursor2 = img2.cursor();
        while (cursor1.hasNext()) {
            cursor1.fwd();
            cursor2.fwd();
            ((FloatType)cursor2.get()).set((FloatType)cursor1.get());
        }
        cursor1.reset();
        cursor2.reset();
        while (cursor2.hasNext()) {
            cursor1.fwd();
            cursor2.fwd();
            ((FloatType)cursor1.get()).set((FloatType)cursor2.get());
        }
        Cursor localizableCursor1 = img1.localizingCursor();
        RandomAccess positionable2 = img2.randomAccess();
        int i = 0;
        while (localizableCursor1.hasNext()) {
            localizableCursor1.fwd();
            if (++i % 2 == 0) {
                positionable2.setPosition(localizableCursor1);
            } else {
                positionable2.setPosition(localizableCursor1);
            }
            FloatType t2 = (FloatType)positionable2.get();
            FloatType t1 = (FloatType)localizableCursor1.get();
            t2.set(t1);
        }
        ExtendedRandomAccessibleInterval extendedImg2 = new ExtendedRandomAccessibleInterval(img2, new OutOfBoundsPeriodicFactory());
        RandomAccess outsideCursor2 = extendedImg2.randomAccess();
        localizableCursor1.reset();
        int[] pos = new int[numDimensions];
        i = 0;
        int direction = 1;
        try {
            while (localizableCursor1.hasNext()) {
                localizableCursor1.fwd();
                localizableCursor1.localize(pos);
                int distance = ++i % 5;
                int n = i % numDimensions;
                pos[n] = (int)((long)pos[n] + img1.dimension(i % numDimensions) * (long)distance * (long)(direction *= -1));
                if (i % 7 == 0) {
                    outsideCursor2.setPosition(pos);
                } else {
                    outsideCursor2.setPosition(pos);
                }
                FloatType t1 = (FloatType)localizableCursor1.get();
                FloatType t2 = (FloatType)outsideCursor2.get();
                t1.set(t2);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println((i % 7 == 0 ? "setPosition() " : "moveTo() ") + Util.printCoordinates(pos));
            e.printStackTrace();
            System.exit(1);
        }
        boolean success = ImgTestHelper.test(img1, reference);
        return success;
    }

    private static float[] createReference(Img<FloatType> img) {
        Random rnd = new Random(1241234L);
        float[] reference = new float[(int)img.size()];
        Cursor cursor = img.cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            float value = rnd.nextFloat();
            reference[i++] = value;
            ((FloatType)cursor.get()).set(value);
        }
        return reference;
    }

    private static boolean test(Img<FloatType> img, float[] reference) {
        boolean allEqual = true;
        Cursor cursor = img.cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            allEqual &= ((FloatType)cursor.get()).get() == reference[i++];
        }
        return allEqual;
    }
}

