/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.real;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ExponentialMathType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.util.Util;

public class DoubleType
extends AbstractRealType<DoubleType>
implements ExponentialMathType<DoubleType>,
NativeType<DoubleType> {
    private int i = 0;
    protected final NativeImg<?, ? extends DoubleAccess> img;
    protected DoubleAccess dataAccess;

    public DoubleType(NativeImg<?, ? extends DoubleAccess> doubleStorage) {
        this.img = doubleStorage;
    }

    public DoubleType(double value) {
        this.img = null;
        this.dataAccess = new DoubleArray(1);
        this.set(value);
    }

    public DoubleType(DoubleAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public DoubleType() {
        this(0.0);
    }

    @Override
    public NativeImg<DoubleType, ? extends DoubleAccess> createSuitableNativeImg(NativeImgFactory<DoubleType> storageFactory, long[] dim) {
        NativeImg<DoubleType, DoubleAccess> container = storageFactory.createDoubleInstance(dim, 1);
        DoubleType linkedType = new DoubleType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public DoubleType duplicateTypeOnSameNativeImg() {
        return new DoubleType(this.img);
    }

    public double get() {
        return this.dataAccess.getValue(this.i);
    }

    @Override
    public void set(double f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public float getRealFloat() {
        return (float)this.get();
    }

    @Override
    public double getRealDouble() {
        return this.get();
    }

    @Override
    public void setReal(float real) {
        this.set(real);
    }

    @Override
    public void setReal(double real) {
        this.set(real);
    }

    @Override
    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getMinValue() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getMinIncrement() {
        return Double.MIN_VALUE;
    }

    @Override
    public DoubleType createVariable() {
        return new DoubleType(0.0);
    }

    @Override
    public DoubleType copy() {
        return new DoubleType(this.get());
    }

    @Override
    public void exp() {
        this.set(Math.exp(this.get()));
    }

    @Override
    public void round() {
        this.set(Util.round(this.get()));
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 64;
    }
}

