/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.util.Util;

public class UnsignedIntType
extends GenericIntType<UnsignedIntType> {
    public UnsignedIntType(NativeImg<?, ? extends IntAccess> img) {
        super(img);
    }

    public UnsignedIntType(long value) {
        super(UnsignedIntType.getCodedSignedIntChecked(value));
    }

    public UnsignedIntType(IntAccess access) {
        super(access);
    }

    public UnsignedIntType() {
        this(0L);
    }

    public static int getCodedSignedIntChecked(long unsignedInt) {
        if (unsignedInt < 0L) {
            unsignedInt = 0L;
        } else if (unsignedInt > 0xFFFFFFFFL) {
            unsignedInt = 0xFFFFFFFFL;
        }
        return UnsignedIntType.getCodedSignedInt(unsignedInt);
    }

    public static int getCodedSignedInt(long unsignedInt) {
        return (int)(unsignedInt & 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getUnsignedInt(int signedInt) {
        return (long)signedInt & 0xFFFFFFFFL;
    }

    @Override
    public NativeImg<UnsignedIntType, ? extends IntAccess> createSuitableNativeImg(NativeImgFactory<UnsignedIntType> storageFactory, long[] dim) {
        NativeImg<UnsignedIntType, IntAccess> container = storageFactory.createIntInstance(dim, 1);
        UnsignedIntType linkedType = new UnsignedIntType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public UnsignedIntType duplicateTypeOnSameNativeImg() {
        return new UnsignedIntType(this.img);
    }

    @Override
    public void mul(float c) {
        long a = UnsignedIntType.getUnsignedInt(this.getValue());
        this.setValue(UnsignedIntType.getCodedSignedInt(Util.round((float)a * c)));
    }

    @Override
    public void mul(double c) {
        long a = UnsignedIntType.getUnsignedInt(this.getValue());
        this.setValue(UnsignedIntType.getCodedSignedInt((int)Util.round((double)a * c)));
    }

    @Override
    public void add(UnsignedIntType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(UnsignedIntType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(UnsignedIntType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(UnsignedIntType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public void setOne() {
        this.set(1L);
    }

    @Override
    public void setZero() {
        this.set(0L);
    }

    @Override
    public void inc() {
        this.set(this.get() + 1L);
    }

    @Override
    public void dec() {
        this.set(this.get() - 1L);
    }

    @Override
    public String toString() {
        return "" + this.get();
    }

    public long get() {
        return UnsignedIntType.getUnsignedInt(this.getValue());
    }

    @Override
    public void set(long f) {
        this.setValue(UnsignedIntType.getCodedSignedInt(f));
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public double getMaxValue() {
        return 4.294967295E9;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int hashCode() {
        long value = this.get();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int compareTo(UnsignedIntType c) {
        long b;
        long a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public UnsignedIntType createVariable() {
        return new UnsignedIntType(0L);
    }

    @Override
    public UnsignedIntType copy() {
        return new UnsignedIntType(this.get());
    }
}

