/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.BitAccess;
import net.imglib2.img.basictypeaccess.array.BitArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;

public class Unsigned12BitType
extends AbstractIntegerType<Unsigned12BitType>
implements NativeType<Unsigned12BitType> {
    private int i = 0;
    protected final NativeImg<Unsigned12BitType, ? extends BitAccess> img;
    int j1;
    int j2;
    int j3;
    int j4;
    int j5;
    int j6;
    int j7;
    int j8;
    int j9;
    int j10;
    int j11;
    int j12;
    protected BitAccess dataAccess;

    public Unsigned12BitType(NativeImg<Unsigned12BitType, ? extends BitAccess> bitStorage) {
        this.img = bitStorage;
        this.updateIndex(0);
    }

    public Unsigned12BitType(short value) {
        this.img = null;
        this.updateIndex(0);
        this.dataAccess = new BitArray(12);
        this.set(value);
    }

    public Unsigned12BitType(BitAccess access) {
        this.img = null;
        this.updateIndex(0);
        this.dataAccess = access;
    }

    public Unsigned12BitType() {
        this(0);
    }

    @Override
    public NativeImg<Unsigned12BitType, ? extends BitAccess> createSuitableNativeImg(NativeImgFactory<Unsigned12BitType> storageFactory, long[] dim) {
        NativeImg<Unsigned12BitType, BitAccess> container = storageFactory.createBitInstance(dim, 12);
        Unsigned12BitType linkedType = new Unsigned12BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Unsigned12BitType duplicateTypeOnSameNativeImg() {
        return new Unsigned12BitType(this.img);
    }

    public short get() {
        short value = 0;
        if (this.dataAccess.getValue(this.j1)) {
            value = (short)(value + 1);
        }
        if (this.dataAccess.getValue(this.j2)) {
            value = (short)(value + 2);
        }
        if (this.dataAccess.getValue(this.j3)) {
            value = (short)(value + 4);
        }
        if (this.dataAccess.getValue(this.j4)) {
            value = (short)(value + 8);
        }
        if (this.dataAccess.getValue(this.j5)) {
            value = (short)(value + 16);
        }
        if (this.dataAccess.getValue(this.j6)) {
            value = (short)(value + 32);
        }
        if (this.dataAccess.getValue(this.j7)) {
            value = (short)(value + 64);
        }
        if (this.dataAccess.getValue(this.j8)) {
            value = (short)(value + 128);
        }
        if (this.dataAccess.getValue(this.j9)) {
            value = (short)(value + 256);
        }
        if (this.dataAccess.getValue(this.j10)) {
            value = (short)(value + 512);
        }
        if (this.dataAccess.getValue(this.j11)) {
            value = (short)(value + 1024);
        }
        if (this.dataAccess.getValue(this.j12)) {
            value = (short)(value + 2048);
        }
        return value;
    }

    @Override
    public void set(short value) {
        this.dataAccess.setValue(this.j1, (value & 1) == 1);
        this.dataAccess.setValue(this.j2, (value & 2) == 2);
        this.dataAccess.setValue(this.j3, (value & 4) == 4);
        this.dataAccess.setValue(this.j4, (value & 8) == 8);
        this.dataAccess.setValue(this.j5, (value & 0x10) == 16);
        this.dataAccess.setValue(this.j6, (value & 0x20) == 32);
        this.dataAccess.setValue(this.j7, (value & 0x40) == 64);
        this.dataAccess.setValue(this.j8, (value & 0x80) == 128);
        this.dataAccess.setValue(this.j9, (value & 0x100) == 256);
        this.dataAccess.setValue(this.j10, (value & 0x200) == 512);
        this.dataAccess.setValue(this.j11, (value & 0x400) == 1024);
        this.dataAccess.setValue(this.j12, (value & 0x800) == 2048);
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set((short)f);
    }

    @Override
    public void setInteger(long f) {
        this.set((short)f);
    }

    @Override
    public double getMaxValue() {
        return 4095.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
        this.j1 = index * 12;
        this.j2 = this.j1 + 1;
        this.j3 = this.j1 + 2;
        this.j4 = this.j1 + 3;
        this.j5 = this.j1 + 4;
        this.j6 = this.j1 + 5;
        this.j7 = this.j1 + 6;
        this.j8 = this.j1 + 7;
        this.j9 = this.j1 + 8;
        this.j10 = this.j1 + 9;
        this.j11 = this.j1 + 10;
        this.j12 = this.j1 + 11;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.j1 += 12;
        this.j2 += 12;
        this.j3 += 12;
        this.j4 += 12;
        this.j5 += 12;
        this.j6 += 12;
        this.j7 += 12;
        this.j8 += 12;
        this.j9 += 12;
        this.j10 += 12;
        this.j11 += 12;
        this.j12 += 12;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc12 = 12 * increment;
        this.j1 += inc12;
        this.j2 += inc12;
        this.j3 += inc12;
        this.j4 += inc12;
        this.j5 += inc12;
        this.j6 += inc12;
        this.j7 += inc12;
        this.j8 += inc12;
        this.j9 += inc12;
        this.j10 += inc12;
        this.j11 += inc12;
        this.j12 += inc12;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.j1 -= 12;
        this.j2 -= 12;
        this.j3 -= 12;
        this.j4 -= 12;
        this.j5 -= 12;
        this.j6 -= 12;
        this.j7 -= 12;
        this.j8 -= 12;
        this.j9 -= 12;
        this.j10 -= 12;
        this.j11 -= 12;
        this.j12 -= 12;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec12 = 12 * decrement;
        this.j1 -= dec12;
        this.j2 -= dec12;
        this.j3 -= dec12;
        this.j4 -= dec12;
        this.j5 -= dec12;
        this.j6 -= dec12;
        this.j7 -= dec12;
        this.j8 -= dec12;
        this.j9 -= dec12;
        this.j10 -= dec12;
        this.j11 -= dec12;
        this.j12 -= dec12;
    }

    @Override
    public Unsigned12BitType createVariable() {
        return new Unsigned12BitType();
    }

    @Override
    public Unsigned12BitType copy() {
        return new Unsigned12BitType(this.get());
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public int getBitsPerPixel() {
        return 12;
    }
}

