/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.util.Util;

public abstract class AbstractIntegerType<T extends AbstractIntegerType<T>>
extends AbstractRealType<T>
implements IntegerType<T> {
    @Override
    public double getMinIncrement() {
        return 1.0;
    }

    @Override
    public float getRealFloat() {
        return this.getIntegerLong();
    }

    @Override
    public double getRealDouble() {
        return this.getIntegerLong();
    }

    @Override
    public void setReal(float real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void setReal(double real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void inc() {
        this.setInteger(this.getIntegerLong() + 1L);
    }

    @Override
    public void dec() {
        this.setInteger(this.getIntegerLong() - 1L);
    }

    @Override
    public void setZero() {
        this.setInteger(0);
    }

    @Override
    public void setOne() {
        this.setInteger(1);
    }

    @Override
    public int hashCode() {
        long value = this.getIntegerLong();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int compareTo(T c) {
        long b;
        long a = this.getIntegerLong();
        if (a > (b = c.getIntegerLong())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "" + this.getIntegerLong();
    }
}

