/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.complex;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.complex.AbstractComplexType;

public class ComplexDoubleType
extends AbstractComplexType<ComplexDoubleType>
implements NativeType<ComplexDoubleType> {
    private int i = 0;
    private int realI = 0;
    private int imaginaryI = 1;
    protected final NativeImg<ComplexDoubleType, ? extends DoubleAccess> img;
    protected DoubleAccess dataAccess;

    public ComplexDoubleType(NativeImg<ComplexDoubleType, ? extends DoubleAccess> complexfloatStorage) {
        this.img = complexfloatStorage;
    }

    public ComplexDoubleType(double r, double i) {
        this.img = null;
        this.dataAccess = new DoubleArray(2);
        this.set(r, i);
    }

    public ComplexDoubleType(DoubleAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public ComplexDoubleType() {
        this(0.0, 0.0);
    }

    @Override
    public NativeImg<ComplexDoubleType, ? extends DoubleAccess> createSuitableNativeImg(NativeImgFactory<ComplexDoubleType> storageFactory, long[] dim) {
        NativeImg<ComplexDoubleType, DoubleAccess> container = storageFactory.createDoubleInstance(dim, 2);
        ComplexDoubleType linkedType = new ComplexDoubleType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public ComplexDoubleType duplicateTypeOnSameNativeImg() {
        return new ComplexDoubleType(this.img);
    }

    @Override
    public float getRealFloat() {
        return (float)this.dataAccess.getValue(this.realI);
    }

    @Override
    public double getRealDouble() {
        return this.dataAccess.getValue(this.realI);
    }

    @Override
    public float getImaginaryFloat() {
        return (float)this.dataAccess.getValue(this.imaginaryI);
    }

    @Override
    public double getImaginaryDouble() {
        return this.dataAccess.getValue(this.imaginaryI);
    }

    @Override
    public void setReal(float r) {
        this.dataAccess.setValue(this.realI, r);
    }

    @Override
    public void setReal(double r) {
        this.dataAccess.setValue(this.realI, r);
    }

    @Override
    public void setImaginary(float i) {
        this.dataAccess.setValue(this.imaginaryI, i);
    }

    @Override
    public void setImaginary(double i) {
        this.dataAccess.setValue(this.imaginaryI, i);
    }

    public void set(double r, double i) {
        this.dataAccess.setValue(this.realI, r);
        this.dataAccess.setValue(this.imaginaryI, i);
    }

    @Override
    public void set(ComplexDoubleType c) {
        this.setReal(c.getRealDouble());
        this.setImaginary(c.getImaginaryDouble());
    }

    @Override
    public ComplexDoubleType createVariable() {
        return new ComplexDoubleType(0.0, 0.0);
    }

    @Override
    public ComplexDoubleType copy() {
        return new ComplexDoubleType(this.getRealFloat(), this.getImaginaryFloat());
    }

    @Override
    public int getEntitiesPerPixel() {
        return 2;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
        this.realI = index * 2;
        this.imaginaryI = index * 2 + 1;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.realI += 2;
        this.imaginaryI += 2;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc2 = 2 * increment;
        this.realI += inc2;
        this.imaginaryI += inc2;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.realI -= 2;
        this.imaginaryI -= 2;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec2 = 2 * decrement;
        this.realI -= dec2;
        this.imaginaryI -= dec2;
    }

    @Override
    public int getIndex() {
        return this.i;
    }
}

