/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.BitAccess;
import net.imglib2.img.basictypeaccess.array.BitArray;
import net.imglib2.type.BasePairType;
import net.imglib2.type.NativeType;

public class BasePairBitType
implements BasePairType<BasePairBitType>,
NativeType<BasePairBitType> {
    private int i = 0;
    protected final NativeImg<BasePairBitType, ? extends BitAccess> img;
    protected BitAccess dataAccess;
    int j1;
    int j2;
    int j3;

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    public BasePairBitType(NativeImg<BasePairBitType, ? extends BitAccess> bitStorage) {
        this.img = bitStorage;
        this.updateIndex(0);
    }

    public BasePairBitType(Base value) {
        this.img = null;
        this.updateIndex(0);
        this.dataAccess = new BitArray(3);
        this.set(value);
    }

    public BasePairBitType() {
        this(Base.N);
    }

    @Override
    public NativeImg<BasePairBitType, ? extends BitAccess> createSuitableNativeImg(NativeImgFactory<BasePairBitType> storageFactory, long[] dim) {
        NativeImg<BasePairBitType, BitAccess> container = storageFactory.createBitInstance(dim, 3);
        BasePairBitType linkedType = new BasePairBitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public BasePairBitType duplicateTypeOnSameNativeImg() {
        return new BasePairBitType(this.img);
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
        this.j1 = index * 3;
        this.j2 = this.j1 + 1;
        this.j3 = this.j1 + 2;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.j1 += 3;
        this.j2 += 3;
        this.j3 += 3;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc3 = 3 * increment;
        this.j1 += inc3;
        this.j2 += inc3;
        this.j3 += inc3;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.j1 -= 3;
        this.j2 -= 3;
        this.j3 -= 3;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec3 = 3 * decrement;
        this.j1 -= dec3;
        this.j2 -= dec3;
        this.j3 -= dec3;
    }

    @Override
    public void set(Base base) {
        boolean b1;
        boolean b2;
        boolean b3;
        switch (base) {
            case A: {
                b3 = false;
                b2 = false;
                b1 = false;
                break;
            }
            case T: {
                b2 = false;
                b1 = false;
                b3 = true;
                break;
            }
            case G: {
                b2 = true;
                b1 = true;
                b3 = false;
                break;
            }
            case C: {
                b1 = false;
                b3 = true;
                b2 = true;
                break;
            }
            case gap: {
                b1 = true;
                b3 = false;
                b2 = false;
                break;
            }
            default: {
                b1 = true;
                b2 = false;
                b3 = true;
            }
        }
        this.dataAccess.setValue(this.j1, b1);
        this.dataAccess.setValue(this.j2, b2);
        this.dataAccess.setValue(this.j3, b3);
    }

    @Override
    public Base get() {
        boolean b1 = this.dataAccess.getValue(this.j1);
        boolean b2 = this.dataAccess.getValue(this.j2);
        boolean b3 = this.dataAccess.getValue(this.j3);
        Base base = !b1 ? (!b2 ? (!b3 ? Base.A : Base.T) : (!b3 ? Base.G : Base.C)) : (!b3 ? Base.gap : Base.N);
        return base;
    }

    @Override
    public int compareTo(BasePairBitType c) {
        Base compare;
        Base input = this.get();
        if (input == (compare = c.get())) {
            return 0;
        }
        switch (input) {
            case gap: {
                return -1;
            }
            case N: {
                return compare == Base.gap ? 1 : -1;
            }
            case A: {
                return compare == Base.gap || compare == Base.N ? 1 : -1;
            }
            case T: {
                return compare == Base.G || compare == Base.C ? -1 : 1;
            }
            case G: {
                return compare == Base.C ? -1 : 1;
            }
        }
        return 1;
    }

    @Override
    public void complement() {
        Base base = this.get();
        switch (base) {
            case A: {
                this.set(Base.T);
                break;
            }
            case T: {
                this.set(Base.A);
                break;
            }
            case G: {
                this.set(Base.C);
                break;
            }
            case C: {
                this.set(Base.G);
                break;
            }
        }
    }

    @Override
    public byte baseToValue() {
        Base base = this.get();
        switch (base) {
            case N: {
                return 1;
            }
            case A: {
                return 2;
            }
            case T: {
                return 3;
            }
            case G: {
                return 4;
            }
            case C: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public void set(BasePairBitType c) {
        this.set(c.get());
    }

    @Override
    public BasePairBitType createVariable() {
        return new BasePairBitType();
    }

    @Override
    public BasePairBitType copy() {
        return new BasePairBitType(this.get());
    }

    public String toString() {
        return this.get().toString();
    }

    public static enum Base {
        gap,
        N,
        A,
        T,
        G,
        C;

    }
}

