/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.transform.integer.AbstractMixedTransform;
import net.imglib2.transform.integer.Slicing;

public class SlicingTransform
extends AbstractMixedTransform
implements Slicing,
Concatenable<Slicing>,
PreConcatenable<Slicing> {
    protected final int numSourceDimensions;
    protected final boolean[] zero;
    protected final long[] translation;
    protected final int[] component;

    public SlicingTransform(int sourceDim, int targetDim) {
        super(targetDim);
        assert (sourceDim <= targetDim);
        this.numSourceDimensions = sourceDim;
        this.translation = new long[targetDim];
        this.zero = new boolean[targetDim];
        this.component = new int[targetDim];
        for (int d = 0; d < targetDim; ++d) {
            if (d < sourceDim) {
                this.component[d] = d;
                continue;
            }
            this.component[d] = 0;
            this.zero[d] = true;
        }
    }

    @Override
    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    @Override
    public void getTranslation(long[] t) {
        assert (t.length == this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            t[d] = this.zero[d] ? this.translation[d] : 0L;
        }
    }

    @Override
    public long getTranslation(int d) {
        assert (d <= this.numTargetDimensions);
        return this.zero[d] ? this.translation[d] : 0L;
    }

    public void setTranslation(long[] t) {
        assert (t.length == this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.translation[d] = t[d];
        }
    }

    @Override
    public void getComponentZero(boolean[] zero) {
        assert (zero.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            zero[d] = this.zero[d];
        }
    }

    @Override
    public boolean getComponentZero(int d) {
        assert (d <= this.numTargetDimensions);
        return this.zero[d];
    }

    public void setComponentZero(boolean[] zero) {
        assert (zero.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.zero[d] = zero[d];
        }
    }

    @Override
    public void getComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            component[d] = this.component[d];
        }
    }

    @Override
    public int getComponentMapping(int d) {
        assert (d <= this.numTargetDimensions);
        return this.component[d];
    }

    public void setComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.component[d] = component[d];
        }
    }

    @Override
    public void apply(long[] source, long[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = this.zero[d] ? this.translation[d] : source[this.component[d]];
        }
    }

    @Override
    public void apply(int[] source, int[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = this.zero[d] ? (int)this.translation[d] : source[this.component[d]];
        }
    }

    @Override
    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.numSourceDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target.setPosition(this.zero[d] ? (long)((int)this.translation[d]) : source.getLongPosition(this.component[d]), d);
        }
    }

    public SlicingTransform concatenate(Slicing t) {
        assert (this.numSourceDimensions == t.numTargetDimensions());
        SlicingTransform result = new SlicingTransform(t.numSourceDimensions(), this.numTargetDimensions);
        for (int d = 0; d < result.numTargetDimensions; ++d) {
            if (this.zero[d]) {
                result.zero[d] = true;
                result.translation[d] = this.translation[d];
                continue;
            }
            int c = this.component[d];
            if (t.getComponentZero(c)) {
                result.zero[d] = true;
                result.translation[d] = t.getTranslation(c);
                continue;
            }
            result.zero[d] = false;
            result.component[d] = t.getComponentMapping(c);
        }
        return result;
    }

    @Override
    public Class<Slicing> getConcatenableClass() {
        return Slicing.class;
    }

    public SlicingTransform preConcatenate(Slicing t) {
        assert (t.numSourceDimensions() == this.numTargetDimensions);
        SlicingTransform result = new SlicingTransform(this.numSourceDimensions, t.numTargetDimensions());
        for (int d = 0; d < result.numTargetDimensions; ++d) {
            if (t.getComponentZero(d)) {
                result.zero[d] = true;
                result.translation[d] = t.getTranslation(d);
                continue;
            }
            int c = t.getComponentMapping(d);
            if (this.zero[c]) {
                result.zero[d] = true;
                result.translation[d] = this.translation[c];
                continue;
            }
            result.zero[d] = false;
            result.component[d] = this.component[c];
        }
        return result;
    }

    @Override
    public Class<Slicing> getPreConcatenableClass() {
        return Slicing.class;
    }

    public void set(Slicing transform) {
        assert (this.numSourceDimensions == transform.numSourceDimensions());
        assert (this.numTargetDimensions == transform.numTargetDimensions());
        transform.getTranslation(this.translation);
        transform.getComponentZero(this.zero);
        transform.getComponentMapping(this.component);
    }

    @Override
    public double[][] getMatrix() {
        int d;
        double[][] mat = new double[this.numTargetDimensions + 1][this.numSourceDimensions + 1];
        mat[this.numTargetDimensions][this.numSourceDimensions] = 1.0;
        for (d = 0; d < this.numTargetDimensions; ++d) {
            mat[d][this.numSourceDimensions] = this.getTranslation(d);
        }
        for (d = 0; d < this.numTargetDimensions; ++d) {
            if (this.zero[d]) continue;
            mat[d][this.component[d]] = 1.0;
        }
        return mat;
    }
}

