/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.roi.AbstractIterableRegionOfInterest;

public class EllipseRegionOfInterest
extends AbstractIterableRegionOfInterest {
    final RealPoint origin;
    final double[] radii;

    public EllipseRegionOfInterest() {
        this(2);
    }

    public EllipseRegionOfInterest(int nDim) {
        super(nDim);
        this.origin = new RealPoint(nDim);
        this.radii = new double[nDim];
    }

    public EllipseRegionOfInterest(RealLocalizable origin, double[] radii) {
        super(origin.numDimensions());
        this.origin = new RealPoint(origin);
        this.radii = new double[origin.numDimensions()];
        System.arraycopy(radii, 0, this.radii, 0, origin.numDimensions());
    }

    public EllipseRegionOfInterest(RealLocalizable origin) {
        this(origin, new double[origin.numDimensions()]);
    }

    public EllipseRegionOfInterest(RealLocalizable origin, double radius) {
        this(origin);
        Arrays.fill(this.radii, radius);
    }

    public void setOrigin(RealLocalizable origin) {
        this.origin.setPosition(origin);
        this.invalidateCachedState();
    }

    public void setOrigin(double[] origin) {
        this.origin.setPosition(origin);
        this.invalidateCachedState();
    }

    public void setOrigin(double origin, int d) {
        this.origin.setPosition(origin, d);
        this.invalidateCachedState();
    }

    public void move(RealLocalizable displacement) {
        this.origin.move(displacement);
        this.invalidateCachedState();
    }

    @Override
    public void move(double[] displacement) {
        this.origin.move(displacement);
        this.invalidateCachedState();
    }

    @Override
    public void move(double displacement, int d) {
        this.origin.move(displacement, d);
        this.invalidateCachedState();
    }

    public double getOrigin(int d) {
        return this.origin.getDoublePosition(d);
    }

    public void getOrigin(RealPositionable orig) {
        orig.setPosition(this.origin);
    }

    public void getOrigin(double[] orig) {
        this.origin.localize(orig);
    }

    public double getRadius(int d) {
        return this.radii[d];
    }

    public void getRadii(double[] r) {
        System.arraycopy(this.radii, 0, r, 0, this.numDimensions());
    }

    public void setRadius(double radius) {
        Arrays.fill(this.radii, radius);
        this.invalidateCachedState();
    }

    public void setRadius(double radius, int d) {
        this.radii[d] = radius;
        this.invalidateCachedState();
    }

    public void setRadii(double[] radii) {
        System.arraycopy(radii, 0, this.radii, 0, this.numDimensions());
        this.invalidateCachedState();
    }

    @Override
    protected void getExtrema(long[] minima, long[] maxima) {
        double[] dMinima = new double[this.numDimensions()];
        double[] dMaxima = new double[this.numDimensions()];
        this.getRealExtrema(dMinima, dMaxima);
        for (int i = 0; i < this.numDimensions(); ++i) {
            minima[i] = (long)Math.ceil(dMinima[i]);
            maxima[i] = (long)Math.floor(dMaxima[i]);
        }
    }

    @Override
    protected void getRealExtrema(double[] minima, double[] maxima) {
        for (int i = 0; i < this.numDimensions(); ++i) {
            minima[i] = this.origin.getDoublePosition(i) - this.radii[i];
            maxima[i] = this.origin.getDoublePosition(i) + this.radii[i];
        }
    }

    @Override
    protected boolean nextRaster(long[] position, long[] end) {
        if (position[this.numDimensions() - 1] < this.min(this.numDimensions() - 1)) {
            this.min(position);
            double d0 = 0.0;
            for (int i = this.numDimensions() - 2; i >= 0; --i) {
                d0 = this.getRasterDisplacement(position, i);
                position[i] = (long)Math.ceil(this.origin.getDoublePosition(i) - d0);
            }
            if (this.isMember(position)) {
                System.arraycopy(position, 1, end, 1, this.numDimensions() - 1);
                end[0] = (long)Math.floor(this.origin.getDoublePosition(0) + d0) + 1L;
                return true;
            }
        }
        for (int i = 1; i < this.numDimensions(); ++i) {
            double diff;
            int j;
            int n = i;
            position[n] = position[n] + 1L;
            double partialDisplacement = this.getPartialDisplacement(position, i);
            if (!(partialDisplacement <= 1.0)) continue;
            double d = 0.0;
            for (j = i; j < this.numDimensions(); ++j) {
                diff = ((double)position[j] - this.origin.getDoublePosition(j)) / this.radii[j];
                d += diff * diff;
            }
            for (j = 0; j < i; ++j) {
                diff = (this.origin.getDoublePosition(j) - (double)Math.round(this.origin.getDoublePosition(j))) / this.radii[j];
                d += diff * diff;
            }
            if (d > 1.0) continue;
            for (j = i - 1; j >= 0; --j) {
                double displacement = this.getRasterDisplacement(position, j);
                position[j] = (long)Math.ceil(this.origin.getDoublePosition(j) - displacement);
                if (j == 0) {
                    end[0] = (long)Math.floor(this.origin.getDoublePosition(0) + displacement) + 1L;
                    continue;
                }
                end[j] = position[j];
            }
            return true;
        }
        return false;
    }

    private double getRasterDisplacement(long[] position, int dim) {
        return Math.sqrt(1.0 - this.getPartialDisplacement(position, dim + 1)) * this.radii[dim];
    }

    private double getPartialDisplacement(long[] position, int dim) {
        double accumulator = 0.0;
        for (int i = dim; i < this.numDimensions(); ++i) {
            double diff = ((double)position[i] - this.origin.getDoublePosition(i)) / this.radii[i];
            accumulator += diff * diff;
        }
        return accumulator;
    }

    @Override
    public boolean contains(double[] position) {
        double accumulator = 0.0;
        for (int i = 0; i < this.numDimensions(); ++i) {
            double diff = (position[i] - this.origin.getDoublePosition(i)) / this.radii[i];
            accumulator += diff * diff;
        }
        return accumulator <= 1.0;
    }

    public boolean isMember(long[] position) {
        double accumulator = 0.0;
        for (int i = 0; i < this.numDimensions(); ++i) {
            double diff = ((double)position[i] - this.origin.getDoublePosition(i)) / this.radii[i];
            accumulator += diff * diff;
        }
        return accumulator <= 1.0;
    }
}

