/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import net.imglib2.roi.AbstractRegionOfInterest;
import net.imglib2.roi.LineRegionOfInterest;

public class AngleRegionOfInterest
extends AbstractRegionOfInterest {
    private final double[] ctr;
    private final double[] end1;
    private final double[] end2;
    private final LineRegionOfInterest line1;
    private final LineRegionOfInterest line2;

    public AngleRegionOfInterest() {
        super(2);
        this.ctr = new double[2];
        this.end1 = new double[2];
        this.end2 = new double[2];
        this.line1 = new LineRegionOfInterest(this.ctr, this.end1);
        this.line2 = new LineRegionOfInterest(this.ctr, this.end2);
        this.invalidateCachedState();
    }

    public AngleRegionOfInterest(double[] ctr, double[] e1, double[] e2) {
        super(ctr.length);
        assert (ctr.length == e1.length);
        assert (ctr.length == e2.length);
        this.ctr = ctr;
        this.end1 = e1;
        this.end2 = e2;
        this.line1 = new LineRegionOfInterest(ctr, this.end1);
        this.line2 = new LineRegionOfInterest(ctr, this.end2);
        this.invalidateCachedState();
    }

    public void getPoint1(double[] pt) {
        System.arraycopy(this.end1, 0, pt, 0, this.end1.length);
    }

    public void getPoint2(double[] pt) {
        System.arraycopy(this.end2, 0, pt, 0, this.end2.length);
    }

    public void getCenter(double[] pt) {
        System.arraycopy(this.ctr, 0, pt, 0, this.ctr.length);
    }

    public void setPoint1(double[] pt) {
        System.arraycopy(pt, 0, this.end1, 0, this.end1.length);
        this.invalidateCachedState();
    }

    public void setPoint2(double[] pt) {
        System.arraycopy(pt, 0, this.end2, 0, this.end2.length);
        this.invalidateCachedState();
    }

    public void setCenter(double[] pt) {
        System.arraycopy(pt, 0, this.ctr, 0, this.ctr.length);
        this.invalidateCachedState();
    }

    public double getPoint1(int dim) {
        return this.end1[dim];
    }

    public double getPoint2(int dim) {
        return this.end2[dim];
    }

    public double getCenter(int dim) {
        return this.ctr[dim];
    }

    public void setPoint1(double val, int dim) {
        this.end1[dim] = val;
        this.invalidateCachedState();
    }

    public void setPoint2(double val, int dim) {
        this.end2[dim] = val;
        this.invalidateCachedState();
    }

    public void setCenter(double val, int dim) {
        this.ctr[dim] = val;
        this.invalidateCachedState();
    }

    @Override
    public void move(double displacement, int d) {
        int n = d;
        this.ctr[n] = this.ctr[n] + displacement;
        int n2 = d;
        this.end1[n2] = this.end1[n2] + displacement;
        int n3 = d;
        this.end2[n3] = this.end2[n3] + displacement;
        this.line1.move(displacement, d);
        this.line2.move(displacement, d);
        this.invalidateCachedState();
    }

    @Override
    public boolean contains(double[] position) {
        return this.line1.contains(position) || this.line2.contains(position);
    }

    @Override
    protected void getRealExtrema(double[] minima, double[] maxima) {
        for (int i = 0; i < this.ctr.length; ++i) {
            minima[i] = Math.min(Math.min(this.end1[i], this.end2[i]), this.ctr[i]);
            maxima[i] = Math.max(Math.max(this.end1[i], this.end2[i]), this.ctr[i]);
        }
    }
}

