/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import net.imglib2.Localizable;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.roi.RegionOfInterest;
import net.imglib2.type.logic.BitType;

public abstract class AbstractRegionOfInterest
implements RegionOfInterest {
    protected int nDimensions;
    private double[] cached_real_min;
    private double[] cached_real_max;

    protected AbstractRegionOfInterest(int nDimensions) {
        this.nDimensions = nDimensions;
    }

    protected abstract void getRealExtrema(double[] var1, double[] var2);

    protected void validateRealExtremaCache() {
        if (this.cached_real_min == null) {
            double[] cachedRealMin = new double[this.nDimensions];
            double[] cachedRealMax = new double[this.nDimensions];
            this.getRealExtrema(cachedRealMin, cachedRealMax);
            this.cached_real_min = cachedRealMin;
            this.cached_real_max = cachedRealMax;
        }
    }

    protected void invalidateCachedState() {
        this.cached_real_min = null;
        this.cached_real_max = null;
    }

    @Override
    public double realMin(int d) {
        this.validateRealExtremaCache();
        return this.cached_real_min[d];
    }

    @Override
    public void realMin(double[] min) {
        this.validateRealExtremaCache();
        for (int i = 0; i < min.length; ++i) {
            min[i] = this.cached_real_min[i];
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        this.validateRealExtremaCache();
        min.setPosition(this.cached_real_min);
    }

    @Override
    public double realMax(int d) {
        this.validateRealExtremaCache();
        return this.cached_real_max[d];
    }

    @Override
    public void realMax(double[] max) {
        this.validateRealExtremaCache();
        for (int i = 0; i < max.length; ++i) {
            max[i] = this.cached_real_max[i];
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        this.validateRealExtremaCache();
        max.setPosition(this.cached_real_max);
    }

    @Override
    public int numDimensions() {
        return this.nDimensions;
    }

    @Override
    public RealRandomAccess<BitType> realRandomAccess() {
        return new AROIRandomAccess();
    }

    @Override
    public RealRandomAccess<BitType> realRandomAccess(RealInterval interval) {
        return this.realRandomAccess();
    }

    @Override
    public void move(double[] displacement) {
        for (int i = 0; i < displacement.length; ++i) {
            this.move(displacement[i], i);
        }
    }

    protected class AROIRandomAccess
    implements RealRandomAccess<BitType> {
        private final BitType bit_type = new BitType();
        private final double[] position;

        protected AROIRandomAccess(AROIRandomAccess randomAccess) {
            this.position = (double[])randomAccess.position.clone();
        }

        public AROIRandomAccess() {
            this.position = new double[AbstractRegionOfInterest.this.nDimensions];
        }

        @Override
        public void localize(float[] pos) {
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = (float)this.position[i];
            }
        }

        @Override
        public void localize(double[] pos) {
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = this.position[i];
            }
        }

        @Override
        public float getFloatPosition(int dim) {
            return (float)this.position[dim];
        }

        @Override
        public double getDoublePosition(int dim) {
            return this.position[dim];
        }

        @Override
        public int numDimensions() {
            return AbstractRegionOfInterest.this.nDimensions;
        }

        @Override
        public void move(float distance, int dim) {
            int n = dim;
            this.position[n] = this.position[n] + (double)distance;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(double distance, int dim) {
            int n = dim;
            this.position[n] = this.position[n] + distance;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(int distance, int dim) {
            int n = dim;
            this.position[n] = this.position[n] + (double)distance;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(long distance, int dim) {
            int n = dim;
            this.position[n] = this.position[n] + (double)distance;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(RealLocalizable localizable) {
            for (int i = 0; i < this.position.length; ++i) {
                int n = i;
                this.position[n] = this.position[n] + localizable.getDoublePosition(i);
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(Localizable localizable) {
            for (int i = 0; i < this.position.length; ++i) {
                int n = i;
                this.position[n] = this.position[n] + localizable.getDoublePosition(i);
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(float[] pos) {
            for (int i = 0; i < pos.length; ++i) {
                int n = i;
                this.position[n] = this.position[n] + (double)pos[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(double[] pos) {
            for (int i = 0; i < pos.length; ++i) {
                int n = i;
                this.position[n] = this.position[n] + pos[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(int[] pos) {
            for (int i = 0; i < pos.length; ++i) {
                int n = i;
                this.position[n] = this.position[n] + (double)pos[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void move(long[] pos) {
            for (int i = 0; i < pos.length; ++i) {
                int n = i;
                this.position[n] = this.position[n] + (double)pos[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(RealLocalizable localizable) {
            localizable.localize(this.position);
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(Localizable localizable) {
            for (int i = 0; i < this.position.length; ++i) {
                this.position[i] = localizable.getDoublePosition(i);
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(float[] position) {
            for (int i = 0; i < position.length; ++i) {
                this.position[i] = position[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(double[] position) {
            for (int i = 0; i < position.length; ++i) {
                this.position[i] = position[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(int[] position) {
            for (int i = 0; i < position.length; ++i) {
                this.position[i] = position[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(long[] position) {
            for (int i = 0; i < position.length; ++i) {
                this.position[i] = position[i];
            }
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(float position, int dim) {
            this.position[dim] = position;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(double position, int dim) {
            this.position[dim] = position;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(int position, int dim) {
            this.position[dim] = position;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void setPosition(long position, int dim) {
            this.position[dim] = position;
            this.updateCachedMembershipStatus();
        }

        protected void updateCachedMembershipStatus() {
            this.bit_type.set(AbstractRegionOfInterest.this.contains(this.position));
        }

        @Override
        public void fwd(int dim) {
            int n = dim;
            this.position[n] = this.position[n] + 1.0;
            this.updateCachedMembershipStatus();
        }

        @Override
        public void bck(int dim) {
            int n = dim;
            this.position[n] = this.position[n] - 1.0;
            this.updateCachedMembershipStatus();
        }

        @Override
        public BitType get() {
            return this.bit_type;
        }

        public AROIRandomAccess copy() {
            return new AROIRandomAccess(this);
        }

        public AROIRandomAccess copyRealRandomAccess() {
            return this.copy();
        }
    }
}

