/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.position.transform;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.position.transform.Floor;

public class RealPositionableFloorPositionable<P extends RealLocalizable & RealPositionable>
extends AbstractEuclideanSpace
implements RealPositionable,
RealLocalizable {
    protected final P source;
    protected final Positionable target;
    protected final long[] floor;

    public RealPositionableFloorPositionable(P source, Positionable target) {
        super(source.numDimensions());
        this.source = source;
        this.target = target;
        this.floor = new long[this.n];
    }

    @Override
    public void move(float distance, int d) {
        ((RealPositionable)this.source).move(distance, d);
        this.target.setPosition(Floor.floor(this.source.getDoublePosition(d)), d);
    }

    @Override
    public void move(double distance, int d) {
        ((RealPositionable)this.source).move(distance, d);
        this.target.setPosition(Floor.floor(this.source.getDoublePosition(d)), d);
    }

    @Override
    public void move(RealLocalizable localizable) {
        ((RealPositionable)this.source).move(localizable);
        Floor.floor(this.source, this.floor);
        this.target.setPosition(this.floor);
    }

    @Override
    public void move(float[] distance) {
        ((RealPositionable)this.source).move(distance);
        Floor.floor(this.source, this.floor);
        this.target.setPosition(this.floor);
    }

    @Override
    public void move(double[] distance) {
        ((RealPositionable)this.source).move(distance);
        Floor.floor(this.source, this.floor);
        this.target.setPosition(this.floor);
    }

    @Override
    public void setPosition(RealLocalizable localizable) {
        ((RealPositionable)this.source).setPosition(localizable);
        Floor.floor(localizable, this.floor);
        this.target.setPosition(this.floor);
    }

    @Override
    public void setPosition(float[] position) {
        ((RealPositionable)this.source).setPosition(position);
        Floor.floor(position, this.floor);
        this.target.setPosition(this.floor);
    }

    @Override
    public void setPosition(double[] position) {
        ((RealPositionable)this.source).setPosition(position);
        Floor.floor(position, this.floor);
        this.target.setPosition(this.floor);
    }

    @Override
    public void setPosition(float position, int d) {
        ((RealPositionable)this.source).setPosition(position, d);
        this.target.setPosition(Floor.floor(position), d);
    }

    @Override
    public void setPosition(double position, int d) {
        ((RealPositionable)this.source).setPosition(position, d);
        this.target.setPosition(Floor.floor(position), d);
    }

    @Override
    public void bck(int d) {
        ((Positionable)this.source).bck(d);
        this.target.bck(d);
    }

    @Override
    public void fwd(int d) {
        ((Positionable)this.source).fwd(d);
        this.target.fwd(d);
    }

    @Override
    public void move(int distance, int d) {
        ((Positionable)this.source).move(distance, d);
        this.target.move(distance, d);
    }

    @Override
    public void move(long distance, int d) {
        ((Positionable)this.source).move(distance, d);
        this.target.move(distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        ((Positionable)this.source).move(localizable);
        this.target.move(localizable);
    }

    @Override
    public void move(int[] position) {
        ((Positionable)this.source).move(position);
        this.target.move(position);
    }

    @Override
    public void move(long[] position) {
        ((Positionable)this.source).move(position);
        this.target.move(position);
    }

    @Override
    public void setPosition(Localizable localizable) {
        ((Positionable)this.source).setPosition(localizable);
        this.target.setPosition(localizable);
    }

    @Override
    public void setPosition(int[] position) {
        ((Positionable)this.source).setPosition(position);
        this.target.setPosition(position);
    }

    @Override
    public void setPosition(long[] position) {
        ((Positionable)this.source).setPosition(position);
        this.target.setPosition(position);
    }

    @Override
    public void setPosition(int position, int d) {
        ((Positionable)this.source).setPosition(position, d);
        this.target.setPosition(position, d);
    }

    @Override
    public void setPosition(long position, int d) {
        ((Positionable)this.source).setPosition(position, d);
        this.target.setPosition(position, d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.source.getDoublePosition(d);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.source.getFloatPosition(d);
    }

    @Override
    public void localize(float[] position) {
        this.source.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.source.localize(position);
    }
}

