/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.collection.KDTree;
import net.imglib2.collection.KDTreeNode;
import net.imglib2.neighborsearch.NearestNeighborSearch;

public class NearestNeighborSearchOnKDTree<T>
implements NearestNeighborSearch<T> {
    protected KDTree<T> tree;
    protected final int n;
    protected final double[] pos;
    protected KDTreeNode<T> bestPoint;
    protected double bestSquDistance;

    public NearestNeighborSearchOnKDTree(KDTree<T> tree) {
        this.n = tree.numDimensions();
        this.pos = new double[this.n];
        this.tree = tree;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public void search(RealLocalizable p) {
        p.localize(this.pos);
        this.bestSquDistance = Double.MAX_VALUE;
        this.searchNode(this.tree.getRoot());
    }

    protected void searchNode(KDTreeNode<T> current) {
        KDTreeNode awayChild;
        double distance = current.squDistanceTo(this.pos);
        if (distance < this.bestSquDistance) {
            this.bestSquDistance = distance;
            this.bestPoint = current;
        }
        double axisDiff = this.pos[current.getSplitDimension()] - current.getSplitCoordinate();
        double axisSquDistance = axisDiff * axisDiff;
        boolean leftIsNearBranch = axisDiff < 0.0;
        KDTreeNode nearChild = leftIsNearBranch ? current.left : current.right;
        KDTreeNode kDTreeNode = awayChild = leftIsNearBranch ? current.right : current.left;
        if (nearChild != null) {
            this.searchNode(nearChild);
        }
        if (axisSquDistance <= this.bestSquDistance && awayChild != null) {
            this.searchNode(awayChild);
        }
    }

    @Override
    public Sampler<T> getSampler() {
        return this.bestPoint;
    }

    @Override
    public RealLocalizable getPosition() {
        return this.bestPoint;
    }

    @Override
    public double getSquareDistance() {
        return this.bestSquDistance;
    }

    @Override
    public double getDistance() {
        return Math.sqrt(this.bestSquDistance);
    }

    @Override
    public NearestNeighborSearchOnKDTree<T> copy() {
        NearestNeighborSearchOnKDTree<T> copy = new NearestNeighborSearchOnKDTree<T>(this.tree);
        System.arraycopy(this.pos, 0, copy.pos, 0, this.pos.length);
        copy.bestPoint = this.bestPoint;
        copy.bestSquDistance = this.bestSquDistance;
        return copy;
    }
}

