/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta.axis;

import java.util.HashMap;
import java.util.Set;
import net.imglib2.meta.AbstractCalibratedAxis;
import net.imglib2.meta.AxisType;

public abstract class VariableAxis
extends AbstractCalibratedAxis {
    private final HashMap<String, Double> vars = new HashMap();

    public VariableAxis(AxisType type) {
        super(type);
    }

    public VariableAxis(AxisType type, String unit) {
        super(type, unit);
    }

    public Double get(String name) {
        return this.vars.get(name);
    }

    public void set(String name, Double value) {
        if (value == null) {
            this.vars.remove(name);
        } else {
            this.vars.put(name, value);
        }
    }

    public int numVars() {
        return this.vars.size();
    }

    public Set<String> vars() {
        return this.vars.keySet();
    }

    @Override
    public String particularEquation() {
        String[] tokens;
        StringBuilder sb = new StringBuilder();
        for (String token : tokens = this.generalEquation().split("(?<=\\w)(?=\\W)|(?<=\\W)(?=\\w)")) {
            Double value;
            if (token.matches("\\w+") && (value = this.vars.get(token)) != null) {
                sb.append("(");
                sb.append(value);
                sb.append(")");
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }
}

