/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta.axis;

import net.imglib2.meta.AxisType;
import net.imglib2.meta.axis.Variable4Axis;

public class RodbardAxis
extends Variable4Axis {
    public RodbardAxis(AxisType type, String unit, double a, double b, double c, double d) {
        super(type, unit, a, b, c, d);
    }

    @Override
    public double calibratedValue(double rawValue) {
        return this.a() + (this.b() - this.a()) / (1.0 + Math.pow(rawValue / this.c(), this.d()));
    }

    @Override
    public double rawValue(double calibratedValue) {
        return Math.pow((this.b() - calibratedValue) / (calibratedValue - this.a()), 1.0 / this.d()) * this.c();
    }

    @Override
    public String generalEquation() {
        return "y = a + (b-a) / (1 + (x/c)^d)";
    }

    @Override
    public RodbardAxis copy() {
        return new RodbardAxis(this.type(), this.unit(), this.a(), this.b(), this.c(), this.d());
    }
}

