/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta.axis;

import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.axis.Variable3Axis;

public class PowerAxis
extends Variable3Axis {
    public PowerAxis(double power) {
        this(Axes.unknown(), power);
    }

    public PowerAxis(AxisType type, double power) {
        this(type, null, 0.0, 1.0, power);
    }

    public PowerAxis(AxisType type, String unit, double a, double b, double c) {
        super(type, unit, a, b, c);
    }

    @Override
    public double calibratedValue(double rawValue) {
        return this.a() + this.b() * Math.pow(rawValue, this.c());
    }

    @Override
    public double rawValue(double calibratedValue) {
        return Math.pow((calibratedValue - this.a()) / this.b(), 1.0 / this.c());
    }

    @Override
    public String generalEquation() {
        return "y = a + b*x^c";
    }

    @Override
    public PowerAxis copy() {
        return new PowerAxis(this.type(), this.unit(), this.a(), this.b(), this.c());
    }
}

