/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta.axis;

import net.imglib2.meta.AxisType;
import net.imglib2.meta.axis.Variable4Axis;

public class ExponentialRecoveryAxis
extends Variable4Axis {
    public ExponentialRecoveryAxis(AxisType type, String unit, double a, double b, double c, double d) {
        super(type, unit, a, b, c, d);
    }

    @Override
    public double calibratedValue(double rawValue) {
        return this.a() + this.b() * (1.0 - Math.exp(this.c() + this.d() * rawValue));
    }

    @Override
    public double rawValue(double calibratedValue) {
        return (Math.log(-((calibratedValue - this.a()) / this.b() - 1.0)) - this.c()) / this.d();
    }

    @Override
    public String generalEquation() {
        return "y = a + b * (1 - exp(c + d*x))";
    }

    @Override
    public ExponentialRecoveryAxis copy() {
        return new ExponentialRecoveryAxis(this.type(), this.unit(), this.a(), this.b(), this.c(), this.d());
    }
}

