/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta.axis;

import net.imglib2.meta.AxisType;
import net.imglib2.meta.axis.Variable3Axis;

public class ChapmanRichardsAxis
extends Variable3Axis {
    public ChapmanRichardsAxis(AxisType type, String unit, double a, double b, double c) {
        super(type, unit, a, b, c);
    }

    @Override
    public double calibratedValue(double rawValue) {
        return Math.pow(this.a() * (1.0 - Math.exp(-this.b() * rawValue)), this.c());
    }

    @Override
    public double rawValue(double calibratedValue) {
        return Math.log(1.0 - Math.pow(calibratedValue / this.a(), 1.0 / this.c())) / -this.b();
    }

    @Override
    public String generalEquation() {
        return "a*(1-exp(-b*x))^c";
    }

    @Override
    public ChapmanRichardsAxis copy() {
        return new ChapmanRichardsAxis(this.type(), this.unit(), this.a(), this.b(), this.c());
    }
}

