/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.display.ColorTable;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.WrappedImg;
import net.imglib2.meta.AbstractCalibratedRealInterval;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.CalibratedSpace;
import net.imglib2.meta.ImgPlusMetadata;
import net.imglib2.meta.axis.DefaultLinearAxis;
import net.imglib2.meta.axis.LinearAxis;

public class ImgPlus<T>
extends AbstractCalibratedRealInterval<CalibratedAxis>
implements Img<T>,
WrappedImg<T>,
ImgPlusMetadata {
    private static final String DEFAULT_NAME = "Untitled";
    private final Img<T> img;
    private String name;
    private String source = "";
    private int validBits;
    private ArrayList<Double> channelMin;
    private ArrayList<Double> channelMax;
    private int compositeChannelCount = 1;
    private final ArrayList<ColorTable> colorTable;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public ImgPlus(Img<T> img) {
        this(img, (String)null, (AxisType[])null, (double[])null);
    }

    public ImgPlus(Img<T> img, String name) {
        this(img, name, (AxisType[])null, (double[])null);
    }

    public ImgPlus(Img<T> img, String name, AxisType[] axes) {
        this(img, name, axes, (double[])null);
    }

    public ImgPlus(Img<T> img, ImgPlusMetadata metadata) {
        this(img, metadata.getName(), ImgPlus.copyAxes(metadata));
        this.validBits = metadata.getValidBits();
        this.compositeChannelCount = metadata.getCompositeChannelCount();
        int count = metadata.getColorTableCount();
        for (int i = 0; i < count; ++i) {
            this.colorTable.add(metadata.getColorTable(i));
        }
    }

    public ImgPlus(Img<T> img, String name, AxisType[] axisTypes, double[] cal) {
        this(img, name, axisTypes, cal, (String[])null);
    }

    public ImgPlus(Img<T> img, String name, AxisType[] axisTypes, double[] cal, String[] units) {
        this(img, name, ImgPlus.createAxes(img, axisTypes, cal, units));
    }

    public ImgPlus(Img<T> img, String name, CalibratedAxis ... axes) {
        super(img, axes);
        this.img = img;
        this.name = ImgPlus.validateName(name);
        this.channelMin = new ArrayList();
        this.channelMax = new ArrayList();
        this.colorTable = new ArrayList();
        this.setSource("");
    }

    @Override
    public Img<T> getImg() {
        return this.img;
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return this.img.randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return this.img.randomAccess(interval);
    }

    @Override
    public long min(int d) {
        return this.img.min(d);
    }

    @Override
    public void min(long[] min) {
        this.img.min(min);
    }

    @Override
    public void min(Positionable min) {
        this.img.min(min);
    }

    @Override
    public long max(int d) {
        return this.img.max(d);
    }

    @Override
    public void max(long[] max) {
        this.img.max(max);
    }

    @Override
    public void max(Positionable max) {
        this.img.max(max);
    }

    @Override
    public void dimensions(long[] dimensions) {
        this.img.dimensions(dimensions);
    }

    @Override
    public long dimension(int d) {
        return this.img.dimension(d);
    }

    @Override
    public double realMin(int d) {
        return this.img.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.img.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.img.realMin(min);
    }

    @Override
    public double realMax(int d) {
        return this.img.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.img.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.img.realMax(max);
    }

    @Override
    public Cursor<T> cursor() {
        return this.img.cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.img.localizingCursor();
    }

    @Override
    public long size() {
        return this.img.size();
    }

    @Override
    public T firstElement() {
        return this.img.firstElement();
    }

    @Override
    public Object iterationOrder() {
        return this.img.iterationOrder();
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public Iterator<T> iterator() {
        return this.img.iterator();
    }

    @Override
    public ImgFactory<T> factory() {
        return this.img.factory();
    }

    @Override
    public ImgPlus<T> copy() {
        return new ImgPlus<T>(this.img.copy(), this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getValidBits() {
        return this.validBits;
    }

    @Override
    public void setValidBits(int bits) {
        this.validBits = bits;
    }

    @Override
    public double getChannelMinimum(int c) {
        if (c < 0 || c >= this.channelMin.size()) {
            return Double.NaN;
        }
        Double d = this.channelMin.get(c);
        return d == null ? Double.NaN : d;
    }

    @Override
    public void setChannelMinimum(int c, double min) {
        if (c < 0) {
            throw new IllegalArgumentException("Invalid channel: " + c);
        }
        if (c >= this.channelMin.size()) {
            this.channelMin.ensureCapacity(c + 1);
            for (int i = this.channelMin.size(); i <= c; ++i) {
                this.channelMin.add(null);
            }
        }
        this.channelMin.set(c, min);
    }

    @Override
    public double getChannelMaximum(int c) {
        if (c < 0 || c >= this.channelMax.size()) {
            return Double.NaN;
        }
        Double d = this.channelMax.get(c);
        return d == null ? Double.NaN : d;
    }

    @Override
    public void setChannelMaximum(int c, double max) {
        if (c < 0) {
            throw new IllegalArgumentException("Invalid channel: " + c);
        }
        if (c >= this.channelMax.size()) {
            this.channelMax.ensureCapacity(c + 1);
            for (int i = this.channelMax.size(); i <= c; ++i) {
                this.channelMax.add(null);
            }
        }
        this.channelMax.set(c, max);
    }

    @Override
    public int getCompositeChannelCount() {
        return this.compositeChannelCount;
    }

    @Override
    public void setCompositeChannelCount(int value) {
        this.compositeChannelCount = value;
    }

    @Override
    public ColorTable getColorTable(int no) {
        if (no >= this.colorTable.size()) {
            return null;
        }
        return this.colorTable.get(no);
    }

    @Override
    public void setColorTable(ColorTable cT, int no) {
        this.colorTable.set(no, cT);
    }

    @Override
    public void initializeColorTables(int count) {
        this.colorTable.ensureCapacity(count);
        this.colorTable.clear();
        for (int i = 0; i < count; ++i) {
            this.colorTable.add(null);
        }
    }

    @Override
    public int getColorTableCount() {
        return this.colorTable.size();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public static <T> ImgPlus<T> wrap(Img<T> img) {
        if (img instanceof ImgPlus) {
            return (ImgPlus)img;
        }
        return new ImgPlus<T>(img);
    }

    public static <T> ImgPlus<T> wrap(Img<T> img, ImgPlusMetadata metadata) {
        if (img instanceof ImgPlus) {
            return (ImgPlus)img;
        }
        return new ImgPlus<T>(img, metadata);
    }

    private static CalibratedAxis[] createAxes(Img<?> img, AxisType[] axisTypes, double[] cal, String[] units) {
        AxisType[] validTypes;
        int numDims = img.numDimensions();
        if (numDims != (validTypes = ImgPlus.validateAxisTypes(numDims, axisTypes)).length) {
            throw new IllegalArgumentException("Axis type count does not match dimensionality: " + validTypes.length + " != " + numDims);
        }
        double[] validCal = ImgPlus.validateCalibration(numDims, cal);
        if (numDims != validCal.length) {
            throw new IllegalArgumentException("Calibration count does not match dimensionality: " + validCal.length + " != " + numDims);
        }
        String[] validUnits = ImgPlus.validateUnits(numDims, units);
        if (numDims != validUnits.length) {
            throw new IllegalArgumentException("Unit count does not match dimensionality: " + validUnits.length + " != " + numDims);
        }
        CalibratedAxis[] axes = new LinearAxis[validTypes.length];
        for (int d = 0; d < numDims; ++d) {
            axes[d] = new DefaultLinearAxis(validTypes[d], validUnits[d], validCal[d]);
        }
        return axes;
    }

    private static String validateName(String name) {
        if (name == null) {
            return DEFAULT_NAME;
        }
        return name;
    }

    private static AxisType[] validateAxisTypes(int numDims, AxisType[] types) {
        if (types != null && numDims == types.length) {
            return types;
        }
        AxisType[] valid = new AxisType[numDims];
        block4: for (int i = 0; i < valid.length; ++i) {
            if (types != null && types.length > i) {
                valid[i] = types[i];
                continue;
            }
            switch (i) {
                case 0: {
                    valid[i] = Axes.X;
                    continue block4;
                }
                case 1: {
                    valid[i] = Axes.Y;
                    continue block4;
                }
                default: {
                    valid[i] = Axes.unknown();
                }
            }
        }
        return valid;
    }

    private static double[] validateCalibration(int numDims, double[] cal) {
        if (cal != null && numDims == cal.length) {
            return cal;
        }
        double[] valid = new double[numDims];
        for (int i = 0; i < valid.length; ++i) {
            valid[i] = cal != null && cal.length > i ? cal[i] : 1.0;
        }
        return valid;
    }

    private static String[] validateUnits(int numDims, String[] units) {
        if (units != null && numDims == units.length) {
            return units;
        }
        String[] valid = new String[numDims];
        for (int i = 0; i < valid.length; ++i) {
            if (units == null || units.length <= i) continue;
            valid[i] = units[i];
        }
        return valid;
    }

    private static CalibratedAxis[] copyAxes(CalibratedSpace<?> space) {
        CalibratedAxis[] axes = new CalibratedAxis[space.numDimensions()];
        for (int d = 0; d < axes.length; ++d) {
            axes[d] = ((CalibratedAxis)space.axis(d)).copy();
        }
        return axes;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

