/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta;

import java.util.List;
import net.imglib2.RealInterval;
import net.imglib2.RealPositionable;
import net.imglib2.meta.AbstractCalibratedSpace;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.CalibratedRealInterval;

public abstract class AbstractCalibratedRealInterval<A extends CalibratedAxis>
extends AbstractCalibratedSpace<A>
implements CalibratedRealInterval<A> {
    private final double[] min;
    private final double[] max;

    public AbstractCalibratedRealInterval(RealInterval interval) {
        super(interval.numDimensions());
        this.min = new double[interval.numDimensions()];
        this.max = (double[])this.min.clone();
        interval.realMin(this.min);
        interval.realMax(this.max);
    }

    public AbstractCalibratedRealInterval(RealInterval interval, A ... axes) {
        super(axes);
        if (interval.numDimensions() != axes.length) {
            throw new IllegalArgumentException("number of provided axes != number of dimensions");
        }
        this.min = new double[interval.numDimensions()];
        this.max = (double[])this.min.clone();
        interval.realMin(this.min);
        interval.realMax(this.max);
    }

    public AbstractCalibratedRealInterval(RealInterval interval, List<A> axes) {
        super(axes);
        if (interval.numDimensions() != axes.size()) {
            throw new IllegalArgumentException("number of provided axes != number of dimensions");
        }
        this.min = new double[interval.numDimensions()];
        this.max = (double[])this.min.clone();
        interval.realMin(this.min);
        interval.realMax(this.max);
    }

    public AbstractCalibratedRealInterval(double[] extents) {
        super(extents.length);
        this.min = new double[extents.length];
        this.max = (double[])extents.clone();
    }

    public AbstractCalibratedRealInterval(double[] extents, A ... axes) {
        super(axes);
        if (extents.length != axes.length) {
            throw new IllegalArgumentException("number of provided axes != number of dimensions");
        }
        this.min = new double[extents.length];
        this.max = (double[])extents.clone();
    }

    public AbstractCalibratedRealInterval(double[] extents, List<A> axes) {
        super(axes);
        if (extents.length != axes.size()) {
            throw new IllegalArgumentException("number of provided axes != number of dimensions");
        }
        this.min = new double[extents.length];
        this.max = (double[])extents.clone();
    }

    public AbstractCalibratedRealInterval(double[] min, double[] max) {
        super(min.length);
        if (min.length != max.length) {
            throw new IllegalArgumentException("number of provided axes != number of dimensions");
        }
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
    }

    public AbstractCalibratedRealInterval(double[] min, double[] max, A ... axes) {
        super(axes);
        if (min.length != max.length || min.length != axes.length) {
            throw new IllegalArgumentException("number of provided axes != number of dimensions");
        }
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
    }

    public AbstractCalibratedRealInterval(double[] min, double[] max, List<A> axes) {
        super(axes);
        if (min.length != max.length || min.length != axes.size()) {
            throw new IllegalArgumentException("number of provided axes != number of dimensions");
        }
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
    }

    @Override
    public double averageScale(int d) {
        return ((CalibratedAxis)this.axis(d)).averageScale(this.realMin(d), this.realMax(d));
    }

    @Override
    public double realMax(int d) {
        return this.max[d];
    }

    @Override
    public void realMax(double[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = this.realMax(i);
        }
    }

    @Override
    public void realMax(RealPositionable dest) {
        for (int i = 0; i < dest.numDimensions(); ++i) {
            dest.setPosition(this.realMax(i), i);
        }
    }

    @Override
    public double realMin(int d) {
        return this.min[d];
    }

    @Override
    public void realMin(double[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = this.realMin(i);
        }
    }

    @Override
    public void realMin(RealPositionable dest) {
        for (int i = 0; i < dest.numDimensions(); ++i) {
            dest.setPosition(this.realMin(i), i);
        }
    }
}

