/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import net.imglib2.Cursor;
import net.imglib2.img.sparse.NtreeImg;
import net.imglib2.iterator.LocalizingIntervalIterator;
import net.imglib2.type.NativeType;

public final class NtreeCursor<T extends NativeType<T>>
extends LocalizingIntervalIterator
implements Cursor<T>,
NtreeImg.PositionProvider {
    private final NtreeImg<T, ?> img;
    private final T type;

    public NtreeCursor(NtreeImg<T, ?> img) {
        super(img);
        this.img = img;
        this.type = img.createLinkedType();
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = 0L;
        }
        this.position[0] = this.position[0] - 1L;
        this.type.updateContainer(this);
    }

    private NtreeCursor(NtreeCursor<T> cursor) {
        super(cursor);
        this.img = cursor.img;
        this.type = this.img.createLinkedType();
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = cursor.position[d];
        }
        this.type.updateContainer(this);
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public T next() {
        this.fwd();
        return (T)this.get();
    }

    @Override
    public void remove() {
    }

    @Override
    public NtreeCursor<T> copy() {
        return new NtreeCursor<T>(this);
    }

    @Override
    public NtreeCursor<T> copyCursor() {
        return this.copy();
    }

    @Override
    public long[] getPosition() {
        return this.position;
    }
}

