/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import net.imglib2.AbstractCursorInt;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;

public class PlanarCursor<T extends NativeType<T>>
extends AbstractCursorInt<T>
implements PlanarImg.PlanarContainerSampler {
    protected final T type;
    protected final PlanarImg<T, ?> container;
    protected final int lastIndex;
    protected final int lastSliceIndex;
    protected int sliceIndex;
    protected int index;

    protected PlanarCursor(PlanarCursor<T> cursor) {
        super(cursor.numDimensions());
        this.container = cursor.container;
        this.type = this.container.createLinkedType();
        this.lastIndex = cursor.lastIndex;
        this.lastSliceIndex = cursor.lastSliceIndex;
        this.sliceIndex = cursor.sliceIndex;
        this.index = cursor.index;
        this.type.updateContainer(this);
        this.type.updateIndex(this.index);
    }

    public PlanarCursor(PlanarImg<T, ?> container) {
        super(container.numDimensions());
        this.type = container.createLinkedType();
        this.container = container;
        this.lastIndex = (this.n > 1 ? container.dimensions[1] : 1) * container.dimensions[0] - 1;
        this.lastSliceIndex = container.numSlices() - 1;
        this.reset();
    }

    @Override
    public int getCurrentSliceIndex() {
        return this.sliceIndex;
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public PlanarCursor<T> copy() {
        return new PlanarCursor<T>(this);
    }

    @Override
    public PlanarCursor<T> copyCursor() {
        return this.copy();
    }

    @Override
    public boolean hasNext() {
        return this.sliceIndex < this.lastSliceIndex || this.index < this.lastIndex;
    }

    @Override
    public void fwd() {
        if (++this.index > this.lastIndex) {
            this.index = 0;
            ++this.sliceIndex;
            this.type.updateContainer(this);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void jumpFwd(long steps) {
        long newIndex = (long)this.index + steps;
        if (newIndex > (long)this.lastIndex) {
            long s = newIndex / (long)(this.lastIndex + 1);
            newIndex -= s * (long)(this.lastIndex + 1);
            this.sliceIndex = (int)((long)this.sliceIndex + s);
            this.type.updateContainer(this);
        }
        this.index = (int)newIndex;
        this.type.updateIndex(this.index);
    }

    @Override
    public void reset() {
        this.sliceIndex = 0;
        this.index = -1;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public void localize(int[] position) {
        this.container.indexToGlobalPosition(this.sliceIndex, this.index, position);
    }

    @Override
    public int getIntPosition(int dim) {
        return this.container.indexToGlobalPosition(this.sliceIndex, this.index, dim);
    }
}

