/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.list;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.list.AbstractListImg;

public class ListRandomAccess<T>
extends AbstractLocalizableInt
implements RandomAccess<T> {
    private int i;
    private final AbstractListImg<T> img;

    public ListRandomAccess(ListRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.img = randomAccess.img;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = randomAccess.position[d];
        }
        this.i = randomAccess.i;
    }

    public ListRandomAccess(AbstractListImg<T> img) {
        super(img.numDimensions());
        this.img = img;
        this.i = 0;
    }

    @Override
    public T get() {
        return this.img.get(this.i);
    }

    public void set(T t) {
        this.img.set(this.i, t);
    }

    @Override
    public void fwd(int d) {
        this.i += this.img.step[d];
        int n = d;
        this.position[n] = this.position[n] + 1;
    }

    @Override
    public void bck(int d) {
        this.i -= this.img.step[d];
        int n = d;
        this.position[n] = this.position[n] - 1;
    }

    @Override
    public void move(int distance, int d) {
        this.i += this.img.step[d] * distance;
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(long distance, int d) {
        this.move((int)distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.move(localizable.getIntPosition(d), d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move((int)distance[d], d);
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
        this.i = this.position[0];
        for (int d = 1; d < this.n; ++d) {
            this.i += this.position[d] * this.img.step[d];
        }
    }

    @Override
    public void setPosition(int[] position) {
        this.position[0] = this.i = position[0];
        for (int d = 1; d < this.n; ++d) {
            int p = position[d];
            this.i += p * this.img.step[d];
            this.position[d] = p;
        }
    }

    @Override
    public void setPosition(long[] position) {
        this.position[0] = this.i = (int)position[0];
        for (int d = 1; d < this.n; ++d) {
            int p = (int)position[d];
            this.i += p * this.img.step[d];
            this.position[d] = p;
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.i += this.img.step[d] * (position - this.position[d]);
        this.position[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.i = (int)((long)this.i + (long)this.img.step[d] * (position - (long)this.position[d]));
        this.position[d] = (int)position;
    }

    @Override
    public ListRandomAccess<T> copy() {
        return new ListRandomAccess<T>(this);
    }

    @Override
    public ListRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

