/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.list;

import java.util.ArrayList;
import java.util.Collection;
import net.imglib2.AbstractCursorInt;
import net.imglib2.Cursor;
import net.imglib2.img.list.AbstractListImg;
import net.imglib2.img.list.ListCursor;
import net.imglib2.type.Type;

public class ListImg<T>
extends AbstractListImg<T> {
    private final ArrayList<T> pixels;

    protected ListImg(long[] dim, T type) {
        super(dim);
        this.pixels = new ArrayList((int)this.numPixels);
        if (type instanceof Type) {
            Type t = (Type)type;
            ArrayList<T> tpixels = this.pixels;
            int i = 0;
            while ((long)i < this.numPixels) {
                tpixels.add(t.createVariable());
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.numPixels) {
                this.pixels.add(null);
                ++i;
            }
        }
    }

    protected ListImg(Collection<T> collection, long[] dim) {
        super(dim);
        this.pixels = new ArrayList((int)this.numPixels);
        this.pixels.addAll(collection);
    }

    @Override
    protected T get(int index) {
        return this.pixels.get(index);
    }

    @Override
    protected void set(int index, T value) {
        this.pixels.set(index, value);
    }

    private static <A extends Type<A>> ListImg<A> copyWithType(ListImg<A> img) {
        ListImg copy = new ListImg(img.dimension, ((Type)img.firstElement()).createVariable());
        Cursor source = img.cursor();
        Cursor target = copy.cursor();
        while (((ListCursor)source).hasNext()) {
            ((Type)((AbstractCursorInt)target).next()).set((Type)((AbstractCursorInt)source).next());
        }
        return copy;
    }

    @Override
    public ListImg<T> copy() {
        Object type = this.firstElement();
        if (type instanceof Type) {
            return ListImg.copyWithType(this);
        }
        return new ListImg<T>(this.pixels, this.dimension);
    }
}

