/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.constant;

import net.imglib2.AbstractLocalizingCursor;
import net.imglib2.type.Type;

public class ConstantLocalizingCursor<T extends Type<T>>
extends AbstractLocalizingCursor<T> {
    long i;
    final long maxNumPixels;
    final T type;
    private final long[] max;

    public ConstantLocalizingCursor(T type, int numDimensions, long[] max, long numPixels) {
        super(numDimensions);
        this.maxNumPixels = numPixels - 1L;
        this.type = type;
        this.max = max;
        this.reset();
    }

    public ConstantLocalizingCursor(ConstantLocalizingCursor<T> cursor) {
        super(cursor.n);
        this.maxNumPixels = cursor.maxNumPixels;
        this.type = cursor.type;
        this.max = cursor.max;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = cursor.position[d];
        }
        this.i = cursor.i;
    }

    @Override
    public void fwd() {
        ++this.i;
        for (int d = 0; d < this.n; ++d) {
            if (this.position[d] >= this.max[d]) continue;
            int n = d;
            this.position[n] = this.position[n] + 1L;
            for (int e = 0; e < d; ++e) {
                this.position[e] = 0L;
            }
            break;
        }
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.maxNumPixels;
    }

    @Override
    public void reset() {
        this.i = -1L;
        this.position[0] = -1L;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = 0L;
        }
    }

    @Override
    public AbstractLocalizingCursor<T> copy() {
        return new ConstantLocalizingCursor<T>(this);
    }

    @Override
    public AbstractLocalizingCursor<T> copyCursor() {
        return this.copy();
    }
}

