/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.cell.AbstractCell;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.type.NativeType;

public class CellRandomAccess<T extends NativeType<T>, A, C extends AbstractCell<A>>
extends AbstractLocalizable
implements RandomAccess<T>,
AbstractCellImg.CellContainerSampler<T, A, C> {
    protected final AbstractCellImg<T, A, C, ?> img;
    protected final T type;
    protected final RandomAccess<C> randomAccessOnCells;
    protected final long[] tmp;
    protected int[] currentCellSteps;
    protected long[] currentCellMin;
    protected long[] currentCellMax;
    protected boolean isOutOfBounds;
    protected final long[] oobCellMin;
    protected final long[] oobCellMax;
    protected int index;

    protected CellRandomAccess(CellRandomAccess<T, A, C> randomAccess) {
        super(randomAccess.numDimensions());
        this.img = randomAccess.img;
        this.type = randomAccess.type.duplicateTypeOnSameNativeImg();
        this.randomAccessOnCells = randomAccess.randomAccessOnCells.copyRandomAccess();
        this.tmp = new long[this.n];
        randomAccess.localize(this.position);
        this.currentCellSteps = randomAccess.currentCellSteps;
        this.currentCellMin = randomAccess.currentCellMin;
        this.currentCellMax = randomAccess.currentCellMax;
        this.isOutOfBounds = randomAccess.isOutOfBounds;
        this.oobCellMin = randomAccess.oobCellMin;
        this.oobCellMax = randomAccess.oobCellMax;
        this.index = randomAccess.index;
        this.type.updateContainer(this);
        this.type.updateIndex(this.index);
    }

    public CellRandomAccess(AbstractCellImg<T, A, C, ?> img) {
        super(img.numDimensions());
        this.img = img;
        this.type = img.createLinkedType();
        this.randomAccessOnCells = img.cells.randomAccess();
        this.tmp = new long[this.n];
        this.isOutOfBounds = false;
        this.oobCellMin = new long[this.n];
        this.oobCellMax = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.oobCellMin[d] = Long.MAX_VALUE;
            this.oobCellMax[d] = Long.MIN_VALUE;
        }
        img.getCellPosition(this.position, this.tmp);
        this.randomAccessOnCells.setPosition(this.tmp);
        this.updatePosition(false);
    }

    @Override
    public C getCell() {
        return (C)((AbstractCell)this.randomAccessOnCells.get());
    }

    @Override
    public T get() {
        return this.type;
    }

    public CellRandomAccess<T, A, C> copy() {
        return new CellRandomAccess<T, A, C>(this);
    }

    public CellRandomAccess<T, A, C> copyRandomAccess() {
        return this.copy();
    }

    @Override
    public void fwd(int d) {
        this.index += this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] + 1L;
        if (this.position[n] > this.currentCellMax[d]) {
            this.randomAccessOnCells.fwd(d);
            this.updatePosition(this.position[d] >= this.img.dimension(d));
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void bck(int d) {
        this.index -= this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] - 1L;
        if (this.position[n] < this.currentCellMin[d]) {
            this.randomAccessOnCells.bck(d);
            this.updatePosition(this.position[d] < 0L);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(int distance, int d) {
        this.index += distance * this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.img.dimension(d));
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(long distance, int d) {
        this.index += (int)distance * this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] + distance;
        if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.img.dimension(d));
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long pos = localizable.getLongPosition(d);
            if (pos == 0L) continue;
            this.index += (int)pos * this.currentCellSteps[d];
            int n = d;
            this.position[n] = this.position[n] + pos;
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
            ++d;
            while (d < this.n) {
                long pos2 = localizable.getLongPosition(d);
                if (pos2 != 0L) {
                    int n2 = d;
                    this.position[n2] = this.position[n2] + pos2;
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            if (distance[d] == 0) continue;
            this.index += distance[d] * this.currentCellSteps[d];
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
            ++d;
            while (d < this.n) {
                if (distance[d] != 0) {
                    int n2 = d;
                    this.position[n2] = this.position[n2] + (long)distance[d];
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            if (distance[d] == 0L) continue;
            this.index += (int)distance[d] * this.currentCellSteps[d];
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
            ++d;
            while (d < this.n) {
                if (distance[d] != 0L) {
                    int n2 = d;
                    this.position[n2] = this.position[n2] + distance[d];
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(int pos, int d) {
        this.index += (int)((long)pos - this.position[d]) * this.currentCellSteps[d];
        this.position[d] = pos;
        if ((long)pos < this.currentCellMin[d] || (long)pos > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(pos / this.img.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.img.dimension(d));
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(long pos, int d) {
        this.index += (int)(pos - this.position[d]) * this.currentCellSteps[d];
        this.position[d] = pos;
        if (pos < this.currentCellMin[d] || pos > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(pos / (long)this.img.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.img.dimension(d));
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long pos = localizable.getLongPosition(d);
            if (pos == this.position[d]) continue;
            this.index += (int)(pos - this.position[d]) * this.currentCellSteps[d];
            this.position[d] = pos;
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
            ++d;
            while (d < this.n) {
                long posInner = localizable.getLongPosition(d);
                if (posInner != this.position[d]) {
                    this.position[d] = posInner;
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            if ((long)pos[d] == this.position[d]) continue;
            this.index += (int)((long)pos[d] - this.position[d]) * this.currentCellSteps[d];
            this.position[d] = pos[d];
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
            ++d;
            while (d < this.n) {
                if ((long)pos[d] != this.position[d]) {
                    this.position[d] = pos[d];
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            if (pos[d] == this.position[d]) continue;
            this.index += (int)(pos[d] - this.position[d]) * this.currentCellSteps[d];
            this.position[d] = pos[d];
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
            ++d;
            while (d < this.n) {
                if (pos[d] != this.position[d]) {
                    this.position[d] = pos[d];
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.img.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.img.dimension(d);
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    private void updatePosition(boolean movedOutOfBounds) {
        if (movedOutOfBounds) {
            this.isOutOfBounds = true;
            this.currentCellMin = this.oobCellMin;
            this.currentCellMax = this.oobCellMax;
        } else {
            if (this.isOutOfBounds) {
                for (int d = 0; d < this.n; ++d) {
                    if (this.position[d] >= 0L && this.position[d] < this.img.dimension(d)) continue;
                    return;
                }
                this.isOutOfBounds = false;
                this.img.getCellPosition(this.position, this.tmp);
                this.randomAccessOnCells.setPosition(this.tmp);
            }
            C cell = this.getCell();
            this.currentCellSteps = ((AbstractCell)cell).steps;
            this.currentCellMin = ((AbstractCell)cell).min;
            this.currentCellMax = ((AbstractCell)cell).max;
            for (int d = 0; d < this.n; ++d) {
                this.tmp[d] = this.position[d] - this.currentCellMin[d];
            }
            this.index = ((AbstractCell)cell).localPositionToIndex(this.tmp);
            this.type.updateContainer(this);
        }
    }
}

