/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractLocalizingCursor;
import net.imglib2.Cursor;
import net.imglib2.img.cell.AbstractCell;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.type.NativeType;

public class CellLocalizingCursor<T extends NativeType<T>, A, C extends AbstractCell<A>>
extends AbstractLocalizingCursor<T>
implements AbstractCellImg.CellContainerSampler<T, A, C> {
    protected final T type;
    protected final Cursor<C> cursorOnCells;
    protected int lastIndexInCell;
    protected long[] currentCellMin;
    protected long[] currentCellMax;
    protected int index;
    protected boolean isNotLastCell;

    protected CellLocalizingCursor(CellLocalizingCursor<T, A, C> cursor) {
        super(cursor.numDimensions());
        this.type = cursor.type.duplicateTypeOnSameNativeImg();
        this.cursorOnCells = cursor.cursorOnCells.copyCursor();
        this.currentCellMin = cursor.currentCellMin;
        this.currentCellMax = cursor.currentCellMax;
        this.isNotLastCell = cursor.isNotLastCell;
        this.lastIndexInCell = cursor.lastIndexInCell;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = cursor.position[d];
        }
        this.index = cursor.index;
        this.type.updateContainer(this);
        this.type.updateIndex(this.index);
    }

    public CellLocalizingCursor(AbstractCellImg<T, A, C, ?> container) {
        super(container.numDimensions());
        this.type = container.createLinkedType();
        this.cursorOnCells = container.cells.cursor();
        this.currentCellMin = null;
        this.currentCellMax = null;
        this.reset();
    }

    @Override
    public C getCell() {
        return (C)((AbstractCell)this.cursorOnCells.get());
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public CellLocalizingCursor<T, A, C> copy() {
        return new CellLocalizingCursor<T, A, C>(this);
    }

    @Override
    public CellLocalizingCursor<T, A, C> copyCursor() {
        return this.copy();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.lastIndexInCell || this.isNotLastCell;
    }

    @Override
    public void jumpFwd(long steps) {
        long newIndex;
        for (newIndex = (long)this.index + steps; newIndex > (long)this.lastIndexInCell; newIndex -= (long)(this.lastIndexInCell + 1)) {
            this.cursorOnCells.fwd();
            this.isNotLastCell = this.cursorOnCells.hasNext();
            this.lastIndexInCell = (int)(((AbstractCell)this.getCell()).size() - 1L);
        }
        C cell = this.getCell();
        this.currentCellMin = ((AbstractCell)cell).min;
        this.currentCellMax = ((AbstractCell)cell).max;
        this.index = (int)newIndex;
        ((AbstractCell)cell).indexToGlobalPosition(this.index, this.position);
        this.type.updateIndex(this.index);
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (++this.index > this.lastIndexInCell) {
            this.moveToNextCell();
            this.index = 0;
        }
        this.type.updateIndex(this.index);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1L;
            if (this.position[n] <= this.currentCellMax[d]) break;
            this.position[d] = this.currentCellMin[d];
        }
    }

    @Override
    public void reset() {
        this.cursorOnCells.reset();
        this.moveToNextCell();
        this.index = -1;
        this.type.updateIndex(this.index);
    }

    private void moveToNextCell() {
        this.cursorOnCells.fwd();
        this.isNotLastCell = this.cursorOnCells.hasNext();
        C cell = this.getCell();
        this.lastIndexInCell = (int)(((AbstractCell)cell).size() - 1L);
        this.currentCellMin = ((AbstractCell)cell).min;
        this.currentCellMax = ((AbstractCell)cell).max;
        this.position[0] = this.currentCellMin[0] - 1L;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = this.currentCellMin[d];
        }
        this.type.updateContainer(this);
    }
}

