/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.cell.AbstractCell;
import net.imglib2.img.cell.AbstractCellImgFactory;
import net.imglib2.img.cell.CellCursor;
import net.imglib2.img.cell.CellIterationOrder;
import net.imglib2.img.cell.CellLocalizingCursor;
import net.imglib2.img.cell.CellRandomAccess;
import net.imglib2.img.cell.Cells;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;

public abstract class AbstractCellImg<T extends NativeType<T>, A, C extends AbstractCell<A>, F extends AbstractCellImgFactory<T>>
extends AbstractNativeImg<T, A> {
    protected final F factory;
    protected final Cells<A, C> cells;
    final int[] cellDims;

    private static long[] getDimensionsFromCells(Cells<?, ?> cells) {
        long[] dim = new long[cells.numDimensions()];
        cells.dimensions(dim);
        return dim;
    }

    public AbstractCellImg(F factory, Cells<A, C> cells) {
        super(AbstractCellImg.getDimensionsFromCells(cells), cells.getEntitiesPerPixel());
        this.factory = factory;
        this.cells = cells;
        this.cellDims = new int[cells.numDimensions()];
        cells.cellDimensions(this.cellDims);
    }

    @Override
    public A update(Object cursor) {
        return ((AbstractCell)((CellContainerSampler)cursor).getCell()).getData();
    }

    protected void getCellPosition(long[] position, long[] cellPos) {
        for (int d = 0; d < this.n; ++d) {
            cellPos[d] = position[d] / (long)this.cellDims[d];
        }
    }

    public CellCursor<T, A, C> cursor() {
        return new CellCursor(this);
    }

    public CellLocalizingCursor<T, A, C> localizingCursor() {
        return new CellLocalizingCursor(this);
    }

    public CellRandomAccess<T, A, C> randomAccess() {
        return new CellRandomAccess(this);
    }

    public F factory() {
        return this.factory;
    }

    @Override
    public CellIterationOrder iterationOrder() {
        return new CellIterationOrder(this);
    }

    public Cells<A, C> getCells() {
        return this.cells;
    }

    protected void copyDataTo(AbstractCellImg<T, ?, ?, ?> copy) {
        Cursor source = this.cursor();
        Cursor target = copy.cursor();
        while (((CellCursor)source).hasNext()) {
            ((NativeType)((AbstractCursor)target).next()).set((Type)((AbstractCursor)source).next());
        }
    }

    public static interface CellContainerSampler<T extends NativeType<T>, A, C extends AbstractCell<A>> {
        public C getCell();
    }
}

