/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.AbstractLocalizingCursorInt;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.IntervalIndexer;

public class ArrayLocalizingCursor<T extends NativeType<T>>
extends AbstractLocalizingCursorInt<T> {
    protected final T type;
    protected final ArrayImg<T, ?> img;
    protected final int lastIndex;
    protected final int[] max;

    protected ArrayLocalizingCursor(ArrayLocalizingCursor<T> cursor) {
        super(cursor.numDimensions());
        this.img = cursor.img;
        this.type = this.img.createLinkedType();
        this.lastIndex = (int)this.img.size() - 1;
        this.max = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = cursor.position[d];
            this.max[d] = cursor.max[d];
        }
        this.type.updateIndex(cursor.type.getIndex());
        this.type.updateContainer(this);
    }

    public ArrayLocalizingCursor(ArrayImg<T, ?> img) {
        super(img.numDimensions());
        this.img = img;
        this.type = img.createLinkedType();
        this.lastIndex = (int)img.size() - 1;
        this.max = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = (int)img.max(d);
        }
        this.reset();
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.lastIndex;
    }

    @Override
    public void fwd() {
        this.position[0] = this.position[0] + 1;
        if (this.position[0] <= this.max[0]) {
            this.type.incIndex();
            return;
        }
        this.position[0] = 0;
        this.type.incIndex();
        for (int d = 1; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] <= this.max[d]) break;
            this.position[d] = 0;
        }
    }

    @Override
    public void jumpFwd(long steps) {
        this.type.incIndex((int)steps);
        IntervalIndexer.indexToPosition(this.type.getIndex(), this.img.dim, this.position);
    }

    @Override
    public void reset() {
        this.type.updateIndex(-1);
        this.position[0] = -1;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public ArrayLocalizingCursor<T> copy() {
        return new ArrayLocalizingCursor<T>(this);
    }

    @Override
    public ArrayLocalizingCursor<T> copyCursor() {
        return this.copy();
    }
}

