/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img;

import java.util.Iterator;
import net.imglib2.Interval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.img.Img;

public abstract class AbstractImg<T>
implements Img<T> {
    protected final int n;
    protected long numPixels;
    protected final long[] dimension;
    protected final long[] max;

    public AbstractImg(long[] size) {
        this.n = size.length;
        this.numPixels = AbstractImg.numElements(size);
        this.dimension = (long[])size.clone();
        this.max = new long[size.length];
        for (int i = 0; i < size.length; ++i) {
            this.max[i] = size[i] - 1L;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public T firstElement() {
        return (T)this.cursor().next();
    }

    public static long numElements(long[] dim) {
        long numPixels = 1L;
        for (int i = 0; i < dim.length; ++i) {
            numPixels *= dim[i];
        }
        return numPixels;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public void dimensions(long[] s) {
        for (int i = 0; i < this.n; ++i) {
            s[i] = this.dimension[i];
        }
    }

    @Override
    public long dimension(int d) {
        try {
            return this.dimension[d];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1L;
        }
    }

    @Override
    public long size() {
        return this.numPixels;
    }

    public String toString() {
        String className = this.getClass().getCanonicalName();
        className = className.substring(className.lastIndexOf(".") + 1, className.length());
        String description = className + " [" + this.dimension[0];
        for (int i = 1; i < this.n; ++i) {
            description = description + "x" + this.dimension[i];
        }
        description = description + "]";
        return description;
    }

    @Override
    public double realMax(int d) {
        return this.max[d];
    }

    @Override
    public void realMax(double[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = this.max[d];
        }
    }

    @Override
    public void realMax(RealPositionable m) {
        m.setPosition(this.max);
    }

    @Override
    public double realMin(int d) {
        return 0.0;
    }

    @Override
    public void realMin(double[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = 0.0;
        }
    }

    @Override
    public void realMin(RealPositionable m) {
        for (int d = 0; d < this.n; ++d) {
            m.setPosition(0, d);
        }
    }

    @Override
    public long max(int d) {
        return this.max[d];
    }

    @Override
    public void max(long[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = this.max[d];
        }
    }

    @Override
    public void max(Positionable m) {
        m.setPosition(this.max);
    }

    @Override
    public void min(long[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = 0L;
        }
    }

    @Override
    public long min(int d) {
        return 0L;
    }

    @Override
    public void min(Positionable m) {
        for (int d = 0; d < this.n; ++d) {
            m.setPosition(0, d);
        }
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }
}

