/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.histogram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.RealPositionable;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.DiscreteFrequencyDistribution;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.integer.LongType;

public class HistogramNd<T>
implements Img<LongType> {
    private List<BinMapper1d<T>> mappers;
    private DiscreteFrequencyDistribution distrib;
    private long[] pos;
    private long ignoredCount;
    private final Incrementer incrementer = new Incrementer();
    private final Decrementer decrementer = new Decrementer();

    public HistogramNd(List<BinMapper1d<T>> mappers) {
        this.mappers = mappers;
        long[] dims = new long[mappers.size()];
        for (int i = 0; i < mappers.size(); ++i) {
            dims[i] = mappers.get(i).getBinCount();
        }
        this.distrib = new DiscreteFrequencyDistribution(dims);
        this.pos = new long[mappers.size()];
        this.ignoredCount = 0L;
    }

    public HistogramNd(HistogramNd<T> other) {
        ArrayList<BinMapper1d<T>> mappersCopy = new ArrayList<BinMapper1d<T>>();
        for (BinMapper1d<T> m : this.mappers) {
            mappersCopy.add(m.copy());
        }
        this.mappers = mappersCopy;
        this.distrib = other.distrib.copy();
        this.pos = (long[])other.pos.clone();
        this.ignoredCount = 0L;
    }

    public HistogramNd(Iterable<List<T>> data, List<BinMapper1d<T>> mappers) {
        this(mappers);
        super.init(data);
    }

    public HistogramNd(List<Iterable<T>> data, List<BinMapper1d<T>> mappers) {
        this(mappers);
        super.init(data);
    }

    public boolean hasTails(int dim) {
        return this.mappers.get(dim).hasTails();
    }

    public boolean hasTails() {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (!this.hasTails(i)) continue;
            return true;
        }
        return false;
    }

    public long lowerTailCount(int dim) {
        if (!this.hasTails(dim)) {
            return 0L;
        }
        long sum = 0L;
        RealCursor cursor = this.distrib.localizingCursor();
        long[] binPos = new long[this.distrib.numDimensions()];
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(binPos);
            if (binPos[dim] != 0L) continue;
            sum += this.distrib.frequency(binPos);
        }
        return sum;
    }

    public long lowerTailCount() {
        if (!this.hasTails()) {
            return 0L;
        }
        long sum = 0L;
        RealCursor cursor = this.distrib.localizingCursor();
        long[] binPos = new long[this.distrib.numDimensions()];
        block0: while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(binPos);
            for (int i = 0; i < this.mappers.size(); ++i) {
                if (binPos[i] != 0L) continue;
                sum += this.distrib.frequency(binPos);
                continue block0;
            }
        }
        return sum;
    }

    public long upperTailCount(int dim) {
        if (!this.hasTails(dim)) {
            return 0L;
        }
        long dimSize = this.mappers.get(dim).getBinCount();
        long sum = 0L;
        RealCursor cursor = this.distrib.localizingCursor();
        long[] binPos = new long[this.distrib.numDimensions()];
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(binPos);
            if (binPos[dim] != dimSize - 1L) continue;
            sum += this.distrib.frequency(binPos);
        }
        return sum;
    }

    public long upperTailCount() {
        if (!this.hasTails()) {
            return 0L;
        }
        long sum = 0L;
        RealCursor cursor = this.distrib.localizingCursor();
        long[] binPos = new long[this.distrib.numDimensions()];
        block0: while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(binPos);
            for (int i = 0; i < this.mappers.size(); ++i) {
                if (binPos[i] != this.mappers.get(i).getBinCount() - 1L) continue;
                sum += this.distrib.frequency(binPos);
                continue block0;
            }
        }
        return sum;
    }

    public long valueCount(int dim) {
        boolean hasTails = this.hasTails(dim);
        long dimSize = this.mappers.get(dim).getBinCount();
        long sum = 0L;
        RealCursor cursor = this.distrib.localizingCursor();
        long[] binPos = new long[this.distrib.numDimensions()];
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(binPos);
            boolean inTail = false;
            if (hasTails && binPos[dim] == 0L || binPos[dim] == dimSize - 1L) {
                inTail = true;
            }
            if (inTail) continue;
            sum += this.distrib.frequency(binPos);
        }
        return sum;
    }

    public long valueCount() {
        if (!this.hasTails()) {
            return this.distributionCount();
        }
        long sum = 0L;
        RealCursor cursor = this.distrib.localizingCursor();
        long[] binPos = new long[this.distrib.numDimensions()];
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(binPos);
            boolean inTail = false;
            for (int i = 0; i < binPos.length; ++i) {
                if (binPos[i] != 0L && binPos[i] != this.mappers.get(i).getBinCount() - 1L) continue;
                inTail = true;
                break;
            }
            if (inTail) continue;
            sum += this.distrib.frequency(binPos);
        }
        return sum;
    }

    public long distributionCount(int dim, long dimVal) {
        long sum = 0L;
        RealCursor cursor = this.distrib.localizingCursor();
        long[] binPos = new long[this.distrib.numDimensions()];
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(binPos);
            if (binPos[dim] != dimVal) continue;
            sum += this.distrib.frequency(binPos);
        }
        return sum;
    }

    public long distributionCount() {
        return this.distrib.totalValues();
    }

    public long ignoredCount() {
        return this.ignoredCount;
    }

    public long totalCount() {
        return this.distributionCount() + this.ignoredCount();
    }

    public long frequency(List<T> values) {
        this.map(values, this.pos);
        return this.frequency(this.pos);
    }

    public long frequency(long[] binPos) {
        return this.distrib.frequency(binPos);
    }

    public double relativeFrequency(List<T> values, boolean includeTails) {
        this.map(values, this.pos);
        return this.relativeFrequency(this.pos, includeTails);
    }

    public double relativeFrequency(long[] binPos, boolean includeTails) {
        double numer = this.frequency(binPos);
        long denom = includeTails ? this.totalCount() : this.valueCount();
        return numer / (double)denom;
    }

    public long getBinCount() {
        if (this.mappers.size() == 0) {
            return 0L;
        }
        long count = 1L;
        for (int i = 0; i < this.mappers.size(); ++i) {
            count *= this.mappers.get(i).getBinCount();
        }
        return count;
    }

    public void map(List<T> values, long[] binPos) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            binPos[i] = this.mappers.get(i).map(values.get(i));
        }
    }

    public void getCenterValues(long[] binPos, List<T> values) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            T value = values.get(i);
            this.mappers.get(i).getCenterValue(binPos[i], value);
        }
    }

    public void getLowerBounds(long[] binPos, List<T> values) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            T value = values.get(i);
            this.mappers.get(i).getLowerBound(binPos[i], value);
        }
    }

    public void getUpperBounds(long[] binPos, List<T> values) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            T value = values.get(i);
            this.mappers.get(i).getUpperBound(binPos[i], value);
        }
    }

    public boolean includesUpperBounds(long[] binPos) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (this.mappers.get(i).includesUpperBound(binPos[i])) continue;
            return false;
        }
        return true;
    }

    public boolean includesLowerBounds(long[] binPos) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (this.mappers.get(i).includesLowerBound(binPos[i])) continue;
            return false;
        }
        return true;
    }

    public boolean includesUpperBound(int dim, long binPos) {
        return this.mappers.get(dim).includesUpperBound(binPos);
    }

    public boolean includesLowerBound(int dim, long binPos) {
        return this.mappers.get(dim).includesLowerBound(binPos);
    }

    public boolean isInLowerTail(List<T> values) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (!this.isInLowerTail(i, values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isInLowerTail(int dim, T value) {
        long binPos;
        return this.hasTails(dim) && (binPos = this.mappers.get(dim).map(value)) == 0L;
    }

    public boolean isInUpperTail(List<T> values) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (!this.isInUpperTail(i, values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isInUpperTail(int dim, T value) {
        long binPos;
        return this.hasTails(dim) && (binPos = this.mappers.get(dim).map(value)) == this.mappers.get(dim).getBinCount() - 1L;
    }

    public boolean isInMiddle(List<T> values) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (this.isInMiddle(i, values.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isInMiddle(int dim, T value) {
        long binPos;
        return !this.hasTails(dim) || (binPos = this.mappers.get(dim).map(value)) != 0L && binPos != this.mappers.get(dim).getBinCount() - 1L;
    }

    public boolean isOutside(List<T> values) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (!this.isOutside(i, values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isOutside(int dim, T value) {
        long binPos = this.mappers.get(dim).map(value);
        return binPos == Long.MIN_VALUE || binPos == Long.MAX_VALUE;
    }

    public DiscreteFrequencyDistribution dfd() {
        return this.distrib;
    }

    public void countData(Iterable<List<T>> data) {
        this.init(data);
    }

    public void countData(List<Iterable<T>> data) {
        this.init(data);
    }

    public void addData(Iterable<List<T>> data) {
        this.add(data);
    }

    public void addData(List<Iterable<T>> data) {
        this.add(data);
    }

    public void subtractData(Iterable<List<T>> data) {
        this.subtract(data);
    }

    public void subtractData(List<Iterable<T>> data) {
        this.subtract(data);
    }

    public void increment(long[] binPos) {
        this.distrib.increment(binPos);
    }

    public void decrement(long[] binPos) {
        this.distrib.decrement(binPos);
    }

    public void increment(List<T> values) {
        this.count(values, this.incrementer);
    }

    public void decrement(List<T> values) {
        this.count(values, this.decrementer);
    }

    public void resetCounters() {
        this.reset();
    }

    @Override
    public int numDimensions() {
        return this.distrib.numDimensions();
    }

    @Override
    public long dimension(int d) {
        return this.distrib.dimension(d);
    }

    @Override
    public void dimensions(long[] dims) {
        this.distrib.dimensions(dims);
    }

    @Override
    public RandomAccess<LongType> randomAccess() {
        return this.distrib.randomAccess();
    }

    @Override
    public RandomAccess<LongType> randomAccess(Interval interval) {
        return this.distrib.randomAccess(interval);
    }

    @Override
    public long min(int d) {
        return this.distrib.min(d);
    }

    @Override
    public void min(long[] min) {
        this.distrib.min(min);
    }

    @Override
    public void min(Positionable min) {
        this.distrib.min(min);
    }

    @Override
    public long max(int d) {
        return this.distrib.max(d);
    }

    @Override
    public void max(long[] max) {
        this.distrib.max(max);
    }

    @Override
    public void max(Positionable max) {
        this.distrib.max(max);
    }

    @Override
    public double realMin(int d) {
        return this.distrib.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.distrib.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.distrib.realMin(min);
    }

    @Override
    public double realMax(int d) {
        return this.distrib.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.distrib.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.distrib.realMax(max);
    }

    @Override
    public Cursor<LongType> cursor() {
        return this.distrib.cursor();
    }

    @Override
    public Cursor<LongType> localizingCursor() {
        return this.distrib.localizingCursor();
    }

    @Override
    public long size() {
        return this.distrib.size();
    }

    @Override
    public LongType firstElement() {
        return this.distrib.firstElement();
    }

    @Override
    public Object iterationOrder() {
        return this.distrib.iterationOrder();
    }

    @Override
    @Deprecated
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.distrib.equalIterationOrder(f);
    }

    @Override
    public Iterator<LongType> iterator() {
        return this.distrib.iterator();
    }

    @Override
    public ImgFactory<LongType> factory() {
        return this.distrib.factory();
    }

    @Override
    public HistogramNd<T> copy() {
        return new HistogramNd<T>(this);
    }

    private void reset() {
        this.distrib.resetCounters();
        this.ignoredCount = 0L;
    }

    private void init(Iterable<List<T>> data) {
        this.reset();
        this.add(data);
    }

    private void init(List<Iterable<T>> data) {
        this.reset();
        this.add(data);
    }

    private void add(Iterable<List<T>> data) {
        this.modifyCounts(data, (Counter)this.incrementer);
    }

    private void add(List<Iterable<T>> data) {
        this.modifyCounts(data, (Counter)this.incrementer);
    }

    private void subtract(Iterable<List<T>> data) {
        this.modifyCounts(data, (Counter)this.decrementer);
    }

    private void subtract(List<Iterable<T>> data) {
        this.modifyCounts(data, (Counter)this.decrementer);
    }

    private void modifyCounts(Iterable<List<T>> data, Counter counter) {
        Iterator<List<T>> iter = data.iterator();
        while (iter.hasNext()) {
            this.count(iter.next(), counter);
        }
    }

    private void modifyCounts(List<Iterable<T>> data, Counter counter) {
        ArrayList vals = new ArrayList(this.mappers.size());
        ArrayList<Iterator<T>> iters = new ArrayList<Iterator<T>>();
        for (int i = 0; i < data.size(); ++i) {
            iters.add(data.get(i).iterator());
            vals.add(null);
        }
        boolean hasNext = true;
        do {
            int i;
            for (i = 0; i < iters.size(); ++i) {
                if (((Iterator)iters.get(i)).hasNext()) continue;
                hasNext = false;
            }
            if (!hasNext) continue;
            for (i = 0; i < iters.size(); ++i) {
                vals.set(i, ((Iterator)iters.get(i)).next());
            }
            this.count(vals, counter);
        } while (hasNext);
    }

    private void count(List<T> values, Counter counter) {
        this.map(values, this.pos);
        boolean ignored = false;
        for (int i = 0; i < this.pos.length; ++i) {
            if (this.pos[i] != Long.MIN_VALUE && this.pos[i] != Long.MAX_VALUE) continue;
            ignored = true;
            break;
        }
        counter.count(this.pos, ignored);
    }

    private class Incrementer
    implements Counter {
        private Incrementer() {
        }

        @Override
        public void count(long[] position, boolean ignored) {
            if (ignored) {
                HistogramNd.this.ignoredCount++;
            } else {
                HistogramNd.this.distrib.increment(position);
            }
        }
    }

    private class Decrementer
    implements Counter {
        private Decrementer() {
        }

        @Override
        public void count(long[] position, boolean ignored) {
            if (ignored) {
                HistogramNd.this.ignoredCount--;
            } else {
                HistogramNd.this.distrib.decrement(position);
            }
        }
    }

    private static interface Counter {
        public void count(long[] var1, boolean var2);
    }
}

