/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector.volatiles;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.converter.Converter;
import net.imglib2.display.projector.IterableIntervalProjector2D;
import net.imglib2.view.Views;

public class Volatile2DRandomAccessibleProjector<T, A extends Volatile<T>, B>
extends IterableIntervalProjector2D<A, B> {
    protected boolean valid = false;

    public Volatile2DRandomAccessibleProjector(int dimX, int dimY, RandomAccessible<A> source, RandomAccessibleInterval<B> target, Converter<? super A, B> converter) {
        super(dimX, dimY, source, Views.iterable(target), converter);
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void map() {
        for (int d = 0; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[0] = this.target.min(0);
        this.min[1] = this.target.min(1);
        this.max[0] = this.target.max(0);
        this.max[1] = this.target.max(1);
        IterableInterval srcIterable = Views.iterable(Views.interval(this.source, new FinalInterval(this.min, this.max)));
        Cursor targetCursor = this.target.localizingCursor();
        if (this.target.iterationOrder().equals(srcIterable.iterationOrder())) {
            Cursor sourceCursor = srcIterable.cursor();
            while (targetCursor.hasNext()) {
                this.converter.convert(sourceCursor.next(), targetCursor.next());
            }
        } else {
            RandomAccess sourceRandomAccess = this.source.randomAccess();
            while (targetCursor.hasNext()) {
                Object b = targetCursor.next();
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(0), 0);
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(1), 1);
                this.converter.convert(sourceRandomAccess.get(), b);
            }
        }
    }
}

