/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector.specialized;

import net.imglib2.display.projector.AbstractProjector2D;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.IntervalIndexer;

public class ArrayImgXYShortProjector<A extends GenericShortType<A>>
extends AbstractProjector2D<A, UnsignedShortType> {
    private final short[] sourceArray;
    private final short[] targetArray;
    private final double min;
    private final double normalizationFactor;
    private final boolean isSigned;
    private final long[] dims;

    public ArrayImgXYShortProjector(ArrayImg<A, ShortArray> source, ArrayImg<UnsignedShortType, ShortArray> target, double normalizationFactor, double min) {
        super(source.numDimensions());
        this.isSigned = ((GenericShortType)source.firstElement()).getMinValue() < 0.0;
        this.targetArray = target.update(null).getCurrentStorageArray();
        this.normalizationFactor = normalizationFactor;
        this.min = min;
        this.dims = new long[this.n];
        source.dimensions(this.dims);
        this.sourceArray = source.update(null).getCurrentStorageArray();
    }

    @Override
    public void map() {
        int i;
        double minCopy = this.min;
        int offset = 0;
        long[] tmpPos = (long[])this.position.clone();
        tmpPos[0] = 0L;
        tmpPos[1] = 0L;
        offset = (int)IntervalIndexer.positionToIndex(tmpPos, this.dims);
        System.arraycopy(this.sourceArray, offset, this.targetArray, 0, this.targetArray.length);
        if (this.isSigned) {
            for (i = 0; i < this.targetArray.length; ++i) {
                this.targetArray[i] = (short)(this.targetArray[i] - 32768);
            }
            minCopy += 32768.0;
        }
        if (this.normalizationFactor != 1.0) {
            for (i = 0; i < this.targetArray.length; ++i) {
                this.targetArray[i] = (short)Math.min(65535L, Math.max(0L, Math.round(((double)(this.targetArray[i] & 0xFFFF) - minCopy) * this.normalizationFactor)));
            }
        }
    }
}

