/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector.sampler;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.display.projector.AbstractProjector2D;
import net.imglib2.display.projector.sampler.IntervalSampler;
import net.imglib2.display.projector.sampler.ProjectedSampler;
import net.imglib2.display.projector.sampler.SelectiveSampler;

public class SamplingProjector2D<A, B>
extends AbstractProjector2D<A, B> {
    private static final int X = 0;
    private static final int Y = 1;
    protected final Converter<ProjectedSampler<A>, B> converter;
    protected final IterableInterval<B> target;
    protected final RandomAccessible<A> source;
    protected final int dimX;
    protected final int dimY;
    private final int projectedDimension;
    private final ProjectedSampler<A> projectionSampler;
    private long projectedDimMinPos;
    private long projectedDimMaxPos;

    public SamplingProjector2D(int dimX, int dimY, RandomAccessible<A> source, IterableInterval<B> target, Converter<ProjectedSampler<A>, B> converter, int projectedDimension, long[] projectedPositions) {
        super(source.numDimensions());
        this.dimX = dimX;
        this.dimY = dimY;
        this.target = target;
        this.source = source;
        this.converter = converter;
        this.projectedDimension = projectedDimension;
        this.projectedDimMinPos = Long.MAX_VALUE;
        this.projectedDimMaxPos = Long.MIN_VALUE;
        for (long pos : projectedPositions) {
            if (pos < this.projectedDimMinPos) {
                this.projectedDimMinPos = pos;
            }
            if (pos <= this.projectedDimMaxPos) continue;
            this.projectedDimMaxPos = pos;
        }
        this.projectionSampler = new SelectiveSampler<A>(projectedDimension, projectedPositions);
    }

    public SamplingProjector2D(int dimX, int dimY, RandomAccessibleInterval<A> source, IterableInterval<B> target, Converter<ProjectedSampler<A>, B> converter, int projectedDimension) {
        super(source.numDimensions());
        this.dimX = dimX;
        this.dimY = dimY;
        this.target = target;
        this.source = source;
        this.converter = converter;
        this.projectedDimension = projectedDimension;
        this.projectedDimMinPos = source.min(projectedDimension);
        this.projectedDimMaxPos = source.max(projectedDimension);
        this.projectionSampler = new IntervalSampler<A>(projectedDimension, this.projectedDimMinPos, this.projectedDimMaxPos);
    }

    @Override
    public void map() {
        for (int d = 0; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[this.dimX] = this.target.min(0);
        this.min[this.dimY] = this.target.min(1);
        this.max[this.dimX] = this.target.max(0);
        this.max[this.dimY] = this.target.max(1);
        this.min[this.projectedDimension] = this.projectedDimMinPos;
        this.max[this.projectedDimension] = this.projectedDimMaxPos;
        FinalInterval sourceInterval = new FinalInterval(this.min, this.max);
        Cursor<B> targetCursor = this.target.localizingCursor();
        RandomAccess<A> sourceRandomAccess = this.source.randomAccess(sourceInterval);
        sourceRandomAccess.setPosition(this.position);
        this.projectionSampler.setRandomAccess(sourceRandomAccess);
        if (this.n > 1) {
            while (targetCursor.hasNext()) {
                this.projectionSampler.reset();
                Object b = targetCursor.next();
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(0), this.dimX);
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(1), this.dimY);
                this.converter.convert(this.projectionSampler, b);
            }
        } else {
            while (targetCursor.hasNext()) {
                this.projectionSampler.reset();
                Object b = targetCursor.next();
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(0), this.dimX);
                this.converter.convert(this.projectionSampler, b);
            }
        }
    }
}

