/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector.sampler;

import net.imglib2.RandomAccess;
import net.imglib2.Sampler;
import net.imglib2.display.projector.sampler.ProjectedSampler;

public class IntervalSampler<T>
implements ProjectedSampler<T> {
    private final int m_projectionDimension;
    private final long m_startPosition;
    private final long m_endPosition;
    private RandomAccess<T> m_source;

    public IntervalSampler(int projectionDimension, long startPosition, long endPosition) {
        this.m_projectionDimension = projectionDimension;
        this.m_startPosition = startPosition;
        this.m_endPosition = endPosition;
    }

    @Override
    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    @Override
    public void fwd() {
        this.m_source.fwd(this.m_projectionDimension);
    }

    @Override
    public void reset() {
        this.m_source.setPosition(this.m_startPosition, this.m_projectionDimension);
    }

    @Override
    public boolean hasNext() {
        return this.m_source.getLongPosition(this.m_projectionDimension) <= this.m_endPosition;
    }

    @Override
    public T get() {
        return this.m_source.get();
    }

    @Override
    public Sampler<T> copy() {
        return this.m_source.copy();
    }

    @Override
    public void setRandomAccess(RandomAccess<T> srcAccess) {
        this.m_source = srcAccess;
    }
}

