/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.display.projector.AbstractProjector2D;
import net.imglib2.view.RandomAccessibleIntervalCursor;
import net.imglib2.view.Views;

public class IterableIntervalProjector2D<A, B>
extends AbstractProjector2D<A, B> {
    protected final Converter<? super A, B> converter;
    protected final RandomAccessible<A> source;
    protected final IterableInterval<B> target;
    final int numDimensions;
    private final int dimX;
    private final int dimY;
    protected final int X = 0;
    protected final int Y = 1;

    public IterableIntervalProjector2D(int dimX, int dimY, RandomAccessible<A> source, IterableInterval<B> target, Converter<? super A, B> converter) {
        super(source.numDimensions());
        this.dimX = dimX;
        this.dimY = dimY;
        this.target = target;
        this.source = source;
        this.converter = converter;
        this.numDimensions = source.numDimensions();
    }

    @Override
    public void map() {
        for (int d = 0; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[this.dimX] = this.target.min(0);
        this.min[this.dimY] = this.target.min(1);
        this.max[this.dimX] = this.target.max(0);
        this.max[this.dimY] = this.target.max(1);
        IterableInterval<A> ii = Views.iterable(Views.interval(this.source, new FinalInterval(this.min, this.max)));
        Cursor<A> sourceCursor = ii.cursor();
        if (this.target.iterationOrder().equals(ii.iterationOrder()) && !(sourceCursor instanceof RandomAccessibleIntervalCursor)) {
            Cursor<B> targetCursor = this.target.cursor();
            while (targetCursor.hasNext()) {
                this.converter.convert(sourceCursor.next(), targetCursor.next());
            }
        } else if (this.target.iterationOrder() instanceof FlatIterationOrder) {
            Cursor<B> targetCursor = this.target.cursor();
            targetCursor.fwd();
            FinalInterval sourceInterval = new FinalInterval(this.min, this.max);
            RandomAccess<A> sourceRandomAccess = this.source.randomAccess(sourceInterval);
            sourceRandomAccess.setPosition(this.position);
            long cr = -this.target.dimension(this.dimX);
            long width = this.target.dimension(this.dimX);
            long height = this.target.dimension(this.dimY);
            sourceRandomAccess.setPosition(this.min);
            for (long y = 0L; y < height; ++y) {
                for (long x = 0L; x < width; ++x) {
                    this.converter.convert(sourceRandomAccess.get(), targetCursor.get());
                    sourceRandomAccess.fwd(this.dimX);
                    targetCursor.fwd();
                }
                sourceRandomAccess.move(cr, this.dimX);
                sourceRandomAccess.fwd(this.dimY);
            }
        } else {
            Cursor<B> targetCursor = this.target.localizingCursor();
            RandomAccess<A> sourceRandomAccess = this.source.randomAccess();
            sourceRandomAccess.setPosition(this.position);
            while (targetCursor.hasNext()) {
                Object b = targetCursor.next();
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(0), this.dimX);
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(1), this.dimY);
                this.converter.convert(sourceRandomAccess.get(), b);
            }
        }
    }
}

