/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.awt;

import java.awt.image.DataBuffer;

public class BitDataBuffer
extends DataBuffer {
    protected static final int bitsPerEntity = 32;
    private final int[] data;
    private final int[][] bankdata;

    public BitDataBuffer(int[] source, int numEntities) {
        super(3, numEntities);
        this.data = source;
        this.bankdata = new int[1][];
        this.bankdata[0] = source;
    }

    protected BitDataBuffer(int numEntities) {
        super(3, numEntities);
        int bufferSize = numEntities % 32 == 0 ? numEntities / 32 : numEntities / 32 + 1;
        this.data = new int[bufferSize];
        this.bankdata = new int[1][];
        this.bankdata[0] = this.data;
    }

    @Override
    public int getElem(int bank, int i) {
        assert (bank == 0);
        int arrayIndex = i / 32;
        int entry = this.data[arrayIndex];
        int arrayOffset = i % 32;
        int value = entry & 1 << arrayOffset;
        return value == 0 ? value : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setElem(int bank, int i, int val) {
        int arrayIndex = i / 32;
        int arrayOffset = i % 32;
        int[] nArray = this.data;
        synchronized (this.data) {
            this.data[arrayIndex] = val == 1 ? this.data[arrayIndex] | 1 << arrayOffset : this.data[arrayIndex] & ~(1 << arrayOffset);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getElem(int i) {
        return this.data[i + this.offset];
    }

    public int[] getData() {
        return this.data;
    }
}

