/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.collection;

import java.util.ArrayList;
import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Point;

public class PointSampleList<T>
extends AbstractInterval
implements IterableInterval<T> {
    protected final ArrayList<Point> coordinates = new ArrayList();
    protected final ArrayList<T> samples = new ArrayList();
    protected int lastIndex = -1;

    private static Interval initInterval(int n) {
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Long.MAX_VALUE;
            max[d] = Long.MIN_VALUE;
        }
        return new FinalInterval(min, max);
    }

    public PointSampleList(int n) {
        super(PointSampleList.initInterval(n));
    }

    public void add(Point position, T sample) {
        this.coordinates.add(position);
        this.samples.add(sample);
        this.lastIndex = this.samples.size() - 1;
        for (int d = 0; d < this.n; ++d) {
            long x = position.getLongPosition(d);
            if (x < this.min[d]) {
                this.min[d] = x;
            }
            if (x <= this.max[d]) continue;
            this.max[d] = x;
        }
    }

    @Override
    public Cursor<T> cursor() {
        return new PointSampleListCursor();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public T firstElement() {
        return this.samples.get(0);
    }

    @Override
    public Cursor<T> localizingCursor() {
        return new PointSampleListCursor();
    }

    @Override
    public long size() {
        return this.samples.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    public class PointSampleListCursor
    implements Cursor<T> {
        protected int index = -1;
        protected Point position = null;
        protected T sample = null;

        @Override
        public Cursor<T> copy() {
            PointSampleListCursor copy = new PointSampleListCursor();
            copy.index = this.index;
            copy.position = this.position;
            copy.sample = this.sample;
            return copy;
        }

        @Override
        public final Cursor<T> copyCursor() {
            return this.copy();
        }

        @Override
        public double getDoublePosition(int d) {
            return this.position.getDoublePosition(d);
        }

        @Override
        public float getFloatPosition(int d) {
            return this.position.getFloatPosition(d);
        }

        @Override
        public int getIntPosition(int d) {
            return this.position.getIntPosition(d);
        }

        @Override
        public long getLongPosition(int d) {
            return this.position.getLongPosition(d);
        }

        @Override
        public void localize(float[] pos) {
            this.position.localize(pos);
        }

        @Override
        public void localize(double[] pos) {
            this.position.localize(pos);
        }

        @Override
        public void localize(int[] pos) {
            this.position.localize(pos);
        }

        @Override
        public void localize(long[] pos) {
            this.position.localize(pos);
        }

        @Override
        public int numDimensions() {
            return PointSampleList.this.n;
        }

        @Override
        public T get() {
            return this.sample;
        }

        @Override
        public void fwd() {
            ++this.index;
            this.position = PointSampleList.this.coordinates.get(this.index);
            this.sample = PointSampleList.this.samples.get(this.index);
        }

        @Override
        public boolean hasNext() {
            return this.index < PointSampleList.this.lastIndex;
        }

        @Override
        public void jumpFwd(long steps) {
            this.index = (int)((long)this.index + steps);
            this.position = PointSampleList.this.coordinates.get(this.index);
            this.sample = PointSampleList.this.samples.get(this.index);
        }

        @Override
        public void reset() {
            this.index = -1;
            this.position = null;
            this.sample = null;
        }

        @Override
        public T next() {
            this.fwd();
            return this.sample;
        }

        @Override
        public void remove() {
        }
    }
}

