/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.collection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import net.imglib2.EuclideanSpace;
import net.imglib2.IterableRealInterval;
import net.imglib2.RealCursor;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.Sampler;
import net.imglib2.collection.KDTreeNode;
import net.imglib2.util.KthElement;

public class KDTree<T>
implements EuclideanSpace,
IterableRealInterval<T> {
    protected final int n;
    protected final KDTreeNode<T> root;
    protected final long size;
    protected final double[] min;
    protected final double[] max;

    public <L extends RealLocalizable> KDTree(List<T> values, List<L> positions) {
        assert (values.size() == positions.size());
        this.n = ((RealLocalizable)positions.get(0)).numDimensions();
        this.size = positions.size();
        assert (KDTree.verifyDimensions(positions, this.n));
        this.min = new double[this.n];
        this.max = new double[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = Double.MAX_VALUE;
            this.max[d] = -1.7976931348623157E308;
        }
        for (RealLocalizable position : positions) {
            for (int d = 0; d < this.n; ++d) {
                double x = position.getDoublePosition(d);
                if (x < this.min[d]) {
                    this.min[d] = x;
                }
                if (!(x > this.max[d])) continue;
                this.max[d] = x;
            }
        }
        if (values == positions) {
            this.root = positions instanceof RandomAccess ? this.makeNode(positions, 0, positions.size() - 1, 0) : this.makeNode(positions.listIterator(), positions.listIterator(positions.size()), 0);
        } else {
            int[] permutation = new int[positions.size()];
            for (int k = 0; k < permutation.length; ++k) {
                permutation[k] = k;
            }
            this.root = positions instanceof RandomAccess ? this.makeNode(positions, 0, positions.size() - 1, 0, values, permutation) : this.makeNode(positions.listIterator(), positions.listIterator(positions.size()), 0, values, permutation);
        }
    }

    public KDTree(IterableRealInterval<T> interval) {
        this.n = interval.numDimensions();
        this.size = interval.size();
        this.min = new double[this.n];
        interval.realMin(this.min);
        this.max = new double[this.n];
        interval.realMax(this.max);
        ArrayList<RealCursor<T>> values = new ArrayList<RealCursor<T>>((int)interval.size());
        RealCursor<T> cursor = interval.localizingCursor();
        while (cursor.hasNext()) {
            cursor.next();
            values.add(cursor.copyCursor());
        }
        this.root = this.makeSamplerNode(values, 0, values.size() - 1, 0);
    }

    protected static <L extends RealLocalizable> boolean verifyDimensions(List<L> positions, int n) {
        for (RealLocalizable position : positions) {
            if (position.numDimensions() == n) continue;
            return false;
        }
        return true;
    }

    protected <L extends RealLocalizable> ValueNode<T> makeNode(List<L> positions, int i, int j, int d, List<T> values, int[] permutation) {
        if (j > i) {
            int k = i + (j - i) / 2;
            KthElement.kthElement(i, j, k, positions, permutation, new DimComparator(d));
            int dChild = d + 1 == this.n ? 0 : d + 1;
            return new ValueNode<T>(values.get(permutation[k]), (RealLocalizable)positions.get(k), d, this.makeNode(positions, i, k - 1, dChild, values, permutation), this.makeNode(positions, k + 1, j, dChild, values, permutation));
        }
        if (j == i) {
            return new ValueNode<T>(values.get(permutation[i]), (RealLocalizable)positions.get(i), d, null, null);
        }
        return null;
    }

    protected <L extends RealLocalizable> ValueNode<T> makeNode(ListIterator<L> first, ListIterator<L> last, int d, List<T> values, int[] permutation) {
        int i = first.nextIndex();
        int j = last.previousIndex();
        if (j > i) {
            int c;
            int k = i + (j - i) / 2;
            KthElement.kthElement(first, last, k, permutation, new DimComparator(d));
            first.previous();
            RealLocalizable current = (RealLocalizable)first.next();
            int dChild = d + 1 == this.n ? 0 : d + 1;
            for (int c2 = j - last.previousIndex(); c2 > 0; --c2) {
                last.next();
            }
            ValueNode<T> right = this.makeNode(first, last, dChild, values, permutation);
            for (c = first.nextIndex() - i; c > 0; --c) {
                first.previous();
            }
            for (c = last.nextIndex() - k; c > 0; --c) {
                last.previous();
            }
            ValueNode<T> left = this.makeNode(first, last, dChild, values, permutation);
            return new ValueNode<T>(values.get(permutation[k]), current, d, left, right);
        }
        if (j == i) {
            RealLocalizable current = (RealLocalizable)first.next();
            return new ValueNode<T>(values.get(permutation[i]), current, d, null, null);
        }
        return null;
    }

    protected <L extends RealLocalizable> ValueNode<T> makeNode(List<L> elements, int i, int j, int d) {
        if (j > i) {
            int k = i + (j - i) / 2;
            KthElement.kthElement(i, j, k, elements, new DimComparator(d));
            int dChild = d + 1 == this.n ? 0 : d + 1;
            return new ValueNode<L>(elements.get(k), (RealLocalizable)elements.get(k), d, this.makeNode(elements, i, k - 1, dChild), this.makeNode(elements, k + 1, j, dChild));
        }
        if (j == i) {
            return new ValueNode<L>(elements.get(i), (RealLocalizable)elements.get(i), d, null, null);
        }
        return null;
    }

    protected <L extends RealLocalizable> ValueNode<T> makeNode(ListIterator<L> first, ListIterator<L> last, int d) {
        int i = first.nextIndex();
        int j = last.previousIndex();
        if (j > i) {
            int c;
            int k = i + (j - i) / 2;
            KthElement.kthElement(first, last, k, new DimComparator(d));
            first.previous();
            RealLocalizable current = (RealLocalizable)first.next();
            int dChild = d + 1 == this.n ? 0 : d + 1;
            for (int c2 = j - last.previousIndex(); c2 > 0; --c2) {
                last.next();
            }
            ValueNode<T> right = this.makeNode(first, last, dChild);
            for (c = first.nextIndex() - i; c > 0; --c) {
                first.previous();
            }
            for (c = last.nextIndex() - k; c > 0; --c) {
                last.previous();
            }
            ValueNode<T> left = this.makeNode(first, last, dChild);
            return new ValueNode<RealLocalizable>(current, current, d, left, right);
        }
        if (j == i) {
            RealLocalizable current = (RealLocalizable)first.next();
            return new ValueNode<RealLocalizable>(current, current, d, null, null);
        }
        return null;
    }

    protected SamplerNode<T> makeSamplerNode(List<RealCursor<T>> elements, int i, int j, int d) {
        if (j > i) {
            int k = i + (j - i) / 2;
            KthElement.kthElement(i, j, k, elements, new DimComparator(d));
            int dChild = d + 1 == this.n ? 0 : d + 1;
            return new SamplerNode<T>(elements.get(k), elements.get(k), d, this.makeSamplerNode(elements, i, k - 1, dChild), this.makeSamplerNode(elements, k + 1, j, dChild));
        }
        if (j == i) {
            return new SamplerNode(elements.get(i), elements.get(i), d, null, null);
        }
        return null;
    }

    public KDTreeNode<T> getRoot() {
        return this.root;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    public String toString(KDTreeNode<T> left, String indent) {
        if (left == null) {
            return "";
        }
        return indent + "- " + left.toString() + "\n" + this.toString(left.left, indent + "  ") + this.toString(left.right, indent + "  ");
    }

    public String toString() {
        return this.toString(this.root, "");
    }

    @Override
    public double realMin(int d) {
        return this.min[d];
    }

    @Override
    public void realMin(double[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = this.min[d];
        }
    }

    @Override
    public void realMin(RealPositionable m) {
        m.setPosition(this.min);
    }

    @Override
    public double realMax(int d) {
        return this.max[d];
    }

    @Override
    public void realMax(double[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = this.max[d];
        }
    }

    @Override
    public void realMax(RealPositionable m) {
        m.setPosition(this.max);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    public KDTreeCursor iterator() {
        return new KDTreeCursor(this);
    }

    public KDTreeCursor cursor() {
        return new KDTreeCursor(this);
    }

    public KDTreeCursor localizingCursor() {
        return new KDTreeCursor(this);
    }

    @Override
    public T firstElement() {
        return this.iterator().next();
    }

    public final class KDTreeCursor
    implements RealCursor<T> {
        private final KDTree<T> tree;
        private final ArrayDeque<KDTreeNode<T>> nodes;
        private KDTreeNode<T> currentNode;

        public KDTreeCursor(KDTree<T> kdtree) {
            this.tree = kdtree;
            int capacity = 2 + (int)(Math.log(kdtree.size()) / Math.log(2.0));
            this.nodes = new ArrayDeque(capacity);
            this.reset();
        }

        public KDTreeCursor(KDTreeCursor c) {
            this.tree = c.tree;
            this.nodes = c.nodes.clone();
            this.currentNode = c.currentNode;
        }

        @Override
        public void localize(float[] position) {
            this.currentNode.localize(position);
        }

        @Override
        public void localize(double[] position) {
            this.currentNode.localize(position);
        }

        @Override
        public float getFloatPosition(int d) {
            return this.currentNode.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.currentNode.getDoublePosition(d);
        }

        @Override
        public int numDimensions() {
            return KDTree.this.n;
        }

        @Override
        public T get() {
            return this.currentNode.get();
        }

        public KDTreeCursor copy() {
            return new KDTreeCursor(this);
        }

        @Override
        public void jumpFwd(long steps) {
            for (long i = 0L; i < steps; ++i) {
                this.fwd();
            }
        }

        @Override
        public void fwd() {
            if (this.nodes.isEmpty()) {
                this.currentNode = null;
            } else {
                this.currentNode = this.nodes.pop();
                if (this.currentNode.left != null) {
                    this.nodes.push(this.currentNode.left);
                }
                if (this.currentNode.right != null) {
                    this.nodes.push(this.currentNode.right);
                }
            }
        }

        @Override
        public void reset() {
            this.nodes.clear();
            this.nodes.push(this.tree.getRoot());
            this.currentNode = null;
        }

        @Override
        public boolean hasNext() {
            return !this.nodes.isEmpty();
        }

        @Override
        public T next() {
            this.fwd();
            return this.get();
        }

        @Override
        public void remove() {
        }

        public KDTreeCursor copyCursor() {
            return this.copy();
        }
    }

    public static final class DimComparator<L extends RealLocalizable>
    implements Comparator<L> {
        final int d;

        public DimComparator(int d) {
            this.d = d;
        }

        @Override
        public int compare(L o1, L o2) {
            float diff = o1.getFloatPosition(this.d) - o2.getFloatPosition(this.d);
            return diff < 0.0f ? -1 : (diff > 0.0f ? 1 : 0);
        }
    }

    protected static final class SamplerNode<T>
    extends KDTreeNode<T> {
        protected final Sampler<T> sampler;

        public SamplerNode(Sampler<T> sampler, RealLocalizable position, int dimension, SamplerNode<T> left, SamplerNode<T> right) {
            super(position, dimension, left, right);
            this.sampler = sampler;
        }

        protected SamplerNode(SamplerNode<T> node) {
            super(node);
            this.sampler = node.sampler.copy();
        }

        @Override
        public T get() {
            return this.sampler.get();
        }

        @Override
        public SamplerNode<T> copy() {
            return new SamplerNode<T>(this);
        }

        public String toString() {
            return "node " + this.getSplitDimension() + " ? " + this.getSplitCoordinate() + " | " + this.sampler.get();
        }
    }

    protected static final class ValueNode<T>
    extends KDTreeNode<T> {
        protected final T value;

        public ValueNode(T value, RealLocalizable position, int dimension, ValueNode<T> left, ValueNode<T> right) {
            super(position, dimension, left, right);
            this.value = value;
        }

        protected ValueNode(ValueNode<T> node) {
            super(node);
            this.value = node.value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public ValueNode<T> copy() {
            return new ValueNode<T>(this);
        }

        public String toString() {
            return "node " + this.getSplitDimension() + " ? " + this.getSplitCoordinate() + " | " + this.value;
        }
    }
}

