/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;

public class RandomAccessibleOnRealRandomAccessible<T>
extends AbstractEuclideanSpace
implements RandomAccessible<T> {
    protected final RealRandomAccessible<T> target;

    public RandomAccessibleOnRealRandomAccessible(RealRandomAccessible<T> target) {
        super(target.numDimensions());
        this.target = target;
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return new RandomAccessOnRealRandomAccessible(this.target.realRandomAccess());
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return new RandomAccessOnRealRandomAccessible(this.target.realRandomAccess(interval));
    }

    protected final class RandomAccessOnRealRandomAccessible
    implements RandomAccess<T> {
        protected final RealRandomAccess<T> targetAccess;

        public RandomAccessOnRealRandomAccessible(RealRandomAccess<T> targetAccess) {
            this.targetAccess = targetAccess;
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < RandomAccessibleOnRealRandomAccessible.this.n; ++d) {
                position[d] = (int)Math.round(this.targetAccess.getDoublePosition(d));
            }
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < RandomAccessibleOnRealRandomAccessible.this.n; ++d) {
                position[d] = Math.round(this.targetAccess.getDoublePosition(d));
            }
        }

        @Override
        public int getIntPosition(int d) {
            return (int)Math.round(this.targetAccess.getDoublePosition(d));
        }

        @Override
        public long getLongPosition(int d) {
            return Math.round(this.targetAccess.getDoublePosition(d));
        }

        @Override
        public void localize(float[] position) {
            this.targetAccess.localize(position);
        }

        @Override
        public void localize(double[] position) {
            this.targetAccess.localize(position);
        }

        @Override
        public float getFloatPosition(int d) {
            return this.targetAccess.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.targetAccess.getDoublePosition(d);
        }

        @Override
        public void fwd(int d) {
            this.targetAccess.fwd(d);
        }

        @Override
        public void bck(int d) {
            this.targetAccess.bck(d);
        }

        @Override
        public void move(int distance, int d) {
            this.targetAccess.move(distance, d);
        }

        @Override
        public void move(long distance, int d) {
            this.targetAccess.move(distance, d);
        }

        @Override
        public void move(Localizable localizable) {
            this.targetAccess.move(localizable);
        }

        @Override
        public void move(int[] distance) {
            this.targetAccess.move(distance);
        }

        @Override
        public void move(long[] distance) {
            this.targetAccess.move(distance);
        }

        @Override
        public void setPosition(Localizable localizable) {
            this.targetAccess.setPosition(localizable);
        }

        @Override
        public void setPosition(int[] position) {
            this.targetAccess.setPosition(position);
        }

        @Override
        public void setPosition(long[] position) {
            this.targetAccess.setPosition(position);
        }

        @Override
        public void setPosition(int position, int d) {
            this.targetAccess.setPosition(position, d);
        }

        @Override
        public void setPosition(long position, int d) {
            this.targetAccess.setPosition(position, d);
        }

        @Override
        public T get() {
            return this.targetAccess.get();
        }

        public RandomAccessOnRealRandomAccessible copy() {
            return new RandomAccessOnRealRandomAccessible(this.targetAccess.copyRealRandomAccess());
        }

        public RandomAccessOnRealRandomAccessible copyRandomAccess() {
            return this.copy();
        }

        @Override
        public int numDimensions() {
            return RandomAccessibleOnRealRandomAccessible.this.n;
        }
    }
}

